/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.configure;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.StringUtils;
import esa.commons.annotation.Internal;
import esa.commons.reflect.AnnotationUtils;
import io.esastack.restlight.core.config.RestlightOptions;
import io.esastack.restlight.core.deploy.ExtensionsHandler;
import io.esastack.restlight.core.deploy.HandlerConfigure;
import io.esastack.restlight.core.deploy.MiniConfigurableDeployments;
import io.esastack.restlight.core.filter.Filter;
import io.esastack.restlight.core.handler.method.ResolvableParamPredicate;
import io.esastack.restlight.core.resolver.context.ContextResolverAdapter;
import io.esastack.restlight.core.resolver.converter.StringConverterFactory;
import io.esastack.restlight.core.resolver.param.ParamResolverFactory;
import io.esastack.restlight.core.resolver.param.entity.RequestEntityResolverAdviceAdapter;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverAdviceAdapter;
import io.esastack.restlight.core.util.ConstructorUtils;
import io.esastack.restlight.core.util.LoggerUtils;
import io.esastack.restlight.jaxrs.adapter.DynamicFeatureAdapter;
import io.esastack.restlight.jaxrs.adapter.JaxrsContextResolverFactory;
import io.esastack.restlight.jaxrs.adapter.JaxrsExceptionMapperAdapter;
import io.esastack.restlight.jaxrs.adapter.JaxrsResponseFiltersAdapter;
import io.esastack.restlight.jaxrs.adapter.MessageBodyReaderAdapter;
import io.esastack.restlight.jaxrs.adapter.MessageBodyWriterAdapter;
import io.esastack.restlight.jaxrs.adapter.PreMatchRequestFiltersAdapter;
import io.esastack.restlight.jaxrs.adapter.ProvidersPredicate;
import io.esastack.restlight.jaxrs.adapter.ReaderInterceptorsAdapter;
import io.esastack.restlight.jaxrs.adapter.StringConverterProviderAdapter;
import io.esastack.restlight.jaxrs.adapter.WriterInterceptorsAdapter;
import io.esastack.restlight.jaxrs.configure.OrderComponent;
import io.esastack.restlight.jaxrs.configure.ProvidersFactory;
import io.esastack.restlight.jaxrs.configure.ProvidersFactoryImpl;
import io.esastack.restlight.jaxrs.configure.ProxyComponent;
import io.esastack.restlight.jaxrs.impl.core.ConfigurableImpl;
import io.esastack.restlight.jaxrs.impl.core.ConfigurationImpl;
import io.esastack.restlight.jaxrs.impl.core.FeatureContextImpl;
import io.esastack.restlight.jaxrs.impl.ext.ProvidersImpl;
import io.esastack.restlight.jaxrs.impl.ext.RuntimeDelegateImpl;
import io.esastack.restlight.jaxrs.resolver.context.ApplicationResolverAdapter;
import io.esastack.restlight.jaxrs.resolver.context.ConfigurationResolverAdapter;
import io.esastack.restlight.jaxrs.resolver.context.ProvidersResolverAdapter;
import io.esastack.restlight.jaxrs.resolver.param.ResourceContextParamResolver;
import io.esastack.restlight.jaxrs.spi.HeaderDelegateFactory;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.RuntimeDelegate;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class JaxrsExtensionsHandler
implements ExtensionsHandler {
    private final ConfigurationImpl configuration = new ConfigurationImpl();
    private final MiniConfigurableDeployments deployments;
    private final ProvidersFactory factory;
    private final Providers providers;

    public JaxrsExtensionsHandler(MiniConfigurableDeployments deployments) {
        Checks.checkNotNull((Object)deployments, (String)"deployments");
        this.deployments = deployments;
        this.factory = new ProvidersFactoryImpl(deployments.deployContext(), this.configuration);
        this.providers = new ProvidersImpl(this.factory);
    }

    public void handle(List<Object> extensions) {
        LinkedList<Object> handleableExtensions = new LinkedList<Object>();
        Object applicationObj = null;
        for (Object extension : extensions) {
            Class userType = ClassUtils.getUserType((Object)extension);
            if (JaxrsUtils.isComponent(userType) || JaxrsUtils.isRootResource(userType)) {
                handleableExtensions.add(extension);
            }
            if (!Application.class.isAssignableFrom(userType)) continue;
            applicationObj = extension;
        }
        ProxyComponent<Application> application = null;
        if (applicationObj != null) {
            application = this.getOrInstantiate(applicationObj, this.deployments, this.configuration, this.providers);
        }
        if (application != null) {
            this.handleApplication(application, this.deployments, this.configuration, handleableExtensions);
        }
        this.deployments.addContextResolver((ContextResolverAdapter)new ConfigurationResolverAdapter(this.configuration));
        this.deployments.addContextResolver((ContextResolverAdapter)new ProvidersResolverAdapter(this.providers));
        this.deployments.addParamResolver((ParamResolverFactory)new ResourceContextParamResolver(this.deployments.deployContext()));
        this.convertThenAddExtensions(this.configuration, this.deployments, handleableExtensions);
        Set<Class<? extends Annotation>> appNameBindings = application == null ? Collections.emptySet() : JaxrsUtils.findNameBindings(ClassUtils.getUserType((Object)application.underlying()));
        this.convertThenAddProviders(appNameBindings, this.factory, this.configuration, this.providers, this.deployments);
    }

    void handleApplication(ProxyComponent<Application> application, MiniConfigurableDeployments deployments, ConfigurationImpl configuration, List<Object> extensions) {
        Map properties;
        Set singletons;
        Set classes;
        ApplicationPath pathAnn = (ApplicationPath)AnnotationUtils.findAnnotation((AnnotatedElement)ClassUtils.getUserType((Object)application.underlying()), ApplicationPath.class);
        if (pathAnn != null) {
            RestlightOptions options = deployments.deployContext().options();
            String contextPath = options.getContextPath();
            String annPath = pathAnn.value();
            if (StringUtils.isEmpty((String)contextPath)) {
                if (StringUtils.isNotEmpty((String)annPath)) {
                    options.setContextPath(annPath);
                }
            } else if (StringUtils.isNotEmpty((String)annPath)) {
                LoggerUtils.logger().warn("The path:[{}] defined in @ApplicationPath has been discarded caused by the existed context-path:[{}]", (Object)annPath, (Object)contextPath);
            }
        }
        if ((classes = application.proxied().getClasses()) != null) {
            extensions.addAll(classes);
        }
        if ((singletons = application.proxied().getSingletons()) != null) {
            extensions.addAll(singletons);
        }
        if ((properties = application.proxied().getProperties()) != null) {
            properties.forEach(configuration::setProperty);
        }
        deployments.addContextResolver((ContextResolverAdapter)new ApplicationResolverAdapter(application.proxied()));
    }

    void convertThenAddExtensions(ConfigurationImpl configuration, MiniConfigurableDeployments deployments, List<Object> extensions) {
        for (Object extension : extensions) {
            boolean isClazz;
            Class userType = ClassUtils.getUserType((Object)extension);
            boolean bl = isClazz = userType == extension;
            if (JaxrsUtils.isRootResource(userType)) {
                if (isClazz) {
                    configuration.addResourceClass(userType);
                    deployments.addController(userType, false);
                    continue;
                }
                configuration.addResourceInstance(extension);
                deployments.addController(extension);
                continue;
            }
            if (isClazz) {
                configuration.addProviderClass(userType, JaxrsUtils.extractContracts((Object)userType, JaxrsUtils.defaultOrder()));
                continue;
            }
            if (extension instanceof RuntimeDelegate.HeaderDelegate) {
                RuntimeDelegateImpl.addHeaderDelegate((RuntimeDelegate.HeaderDelegate)extension);
                continue;
            }
            if (extension instanceof HeaderDelegateFactory) {
                RuntimeDelegateImpl.addHeaderDelegateFactory((HeaderDelegateFactory)extension);
                continue;
            }
            configuration.addProviderInstance(extension, JaxrsUtils.extractContracts(extension, JaxrsUtils.defaultOrder()));
        }
    }

    void convertThenAddProviders(Set<Class<? extends Annotation>> appNameBindings, ProvidersFactory factory, ConfigurationImpl configuration, Providers providers, MiniConfigurableDeployments deployments) {
        Collection<ProxyComponent<Feature>> features = factory.features();
        if (!features.isEmpty()) {
            ConfigurableImpl configurable = new ConfigurableImpl(configuration);
            for (ProxyComponent<Feature> feature : features) {
                FeatureContextImpl context = new FeatureContextImpl(ClassUtils.getUserType((Object)feature.underlying()), configurable);
                if (!feature.proxied().configure((FeatureContext)context)) continue;
                configuration.addEnabledFeature(feature.underlying());
            }
        }
        deployments.addRequestEntityResolver(new MessageBodyReaderAdapter(providers));
        deployments.addResponseEntityResolver(new MessageBodyWriterAdapter(providers));
        for (ProxyComponent proxyComponent : factory.exceptionMappers()) {
            deployments.addExceptionResolver(ClassUtils.findFirstGenericType((Class)ClassUtils.getUserType((Object)proxyComponent.underlying())).orElse(Throwable.class), new JaxrsExceptionMapperAdapter(proxyComponent));
        }
        deployments.addParamResolver((ParamResolverFactory)new JaxrsContextResolverFactory(providers));
        for (ProxyComponent<ExceptionMapper<Throwable>> proxyComponent : factory.paramConverterProviders()) {
            deployments.addStringConverter((StringConverterFactory)new StringConverterProviderAdapter((ParamConverterProvider)proxyComponent.proxied(), JaxrsUtils.getOrder(proxyComponent.underlying())));
        }
        this.convertThenAddFilters(appNameBindings, deployments, factory);
        this.convertThenAddInterceptors(appNameBindings, deployments, factory);
        deployments.addHandlerConfigure((HandlerConfigure)new DynamicFeatureAdapter(deployments.deployContext(), appNameBindings, factory.dynamicFeatures(), configuration));
    }

    void convertThenAddFilters(Set<Class<? extends Annotation>> appNameBindings, MiniConfigurableDeployments deployments, ProvidersFactory factory) {
        LinkedList reqFilters = new LinkedList();
        for (ProxyComponent<ContainerRequestFilter> filter : factory.requestFilters()) {
            if (!JaxrsUtils.isPreMatched(filter.underlying())) continue;
            reqFilters.add(new OrderComponent<ContainerRequestFilter>(filter.proxied(), JaxrsUtils.getOrder(filter.underlying())));
        }
        if (!reqFilters.isEmpty()) {
            deployments.addFilter((Filter)new PreMatchRequestFiltersAdapter(JaxrsUtils.ascendingOrdered(reqFilters).toArray(new ContainerRequestFilter[0])));
        }
        LinkedList rspFilters = new LinkedList();
        for (ProxyComponent<ContainerResponseFilter> filter : factory.responseFilters()) {
            if (!JaxrsExtensionsHandler.isGlobalComponent(appNameBindings, filter.underlying())) continue;
            rspFilters.add(new OrderComponent<ContainerResponseFilter>(filter.proxied(), JaxrsUtils.getOrder(filter.underlying())));
        }
        deployments.addFilter((Filter)new JaxrsResponseFiltersAdapter(JaxrsUtils.descendingOrder(rspFilters).toArray(new ContainerResponseFilter[0])));
    }

    void convertThenAddInterceptors(Set<Class<? extends Annotation>> appNameBindings, MiniConfigurableDeployments deployments, ProvidersFactory factory) {
        LinkedList readInterceptors = new LinkedList();
        for (ProxyComponent<ReaderInterceptor> interceptor : factory.readerInterceptors()) {
            if (!JaxrsExtensionsHandler.isGlobalComponent(appNameBindings, interceptor.underlying())) continue;
            readInterceptors.add(new OrderComponent<ReaderInterceptor>(interceptor.proxied(), JaxrsUtils.getOrder(interceptor.underlying())));
        }
        if (!readInterceptors.isEmpty()) {
            deployments.addRequestEntityResolverAdvice((RequestEntityResolverAdviceAdapter)new ReaderInterceptorsAdapter(JaxrsUtils.ascendingOrdered(readInterceptors).toArray(new ReaderInterceptor[0]), ProvidersPredicate.BINDING_GLOBAL));
        }
        LinkedList writerInterceptors = new LinkedList();
        for (ProxyComponent<WriterInterceptor> interceptor : factory.writerInterceptors()) {
            if (!JaxrsExtensionsHandler.isGlobalComponent(appNameBindings, interceptor.underlying())) continue;
            writerInterceptors.add(new OrderComponent<WriterInterceptor>(interceptor.proxied(), JaxrsUtils.getOrder(interceptor.underlying())));
        }
        if (!writerInterceptors.isEmpty()) {
            deployments.addResponseEntityResolverAdvice((ResponseEntityResolverAdviceAdapter)new WriterInterceptorsAdapter(JaxrsUtils.ascendingOrdered(writerInterceptors).toArray(new WriterInterceptor[0]), ProvidersPredicate.BINDING_GLOBAL));
        }
    }

    ProxyComponent<Application> getOrInstantiate(Object object, MiniConfigurableDeployments deployments, ConfigurationImpl configuration, Providers providers) {
        if (object instanceof Application) {
            return new ProxyComponent<Application>(object, (Application)object);
        }
        Class userType = ClassUtils.getUserType((Object)object);
        if (!deployments.deployContext().paramPredicate().isPresent()) {
            throw new IllegalStateException("Failed to instantiate class: [" + userType + "], because there is" + " no [" + ResolvableParamPredicate.class + "] exist!");
        }
        Constructor constructor = ConstructorUtils.extractResolvable((Class)userType, (ResolvableParamPredicate)((ResolvableParamPredicate)deployments.deployContext().paramPredicate().get()));
        if (constructor == null) {
            throw new IllegalStateException("There is no suitable constructor to instantiate class: " + userType.getName());
        }
        Object[] args = new Object[constructor.getParameterCount()];
        int index = 0;
        for (Parameter parameter : constructor.getParameters()) {
            if (!parameter.isAnnotationPresent(Context.class)) {
                throw new IllegalStateException("Failed to instantiate class: [" + userType + "] caused by" + " unresolvable parameter: [" + parameter.getName() + "], maybe @Context is absent?");
            }
            if (Configuration.class.isAssignableFrom(parameter.getType())) {
                args[index++] = configuration;
                continue;
            }
            if (Providers.class.isAssignableFrom(parameter.getType())) {
                args[index++] = providers;
                continue;
            }
            throw new IllegalStateException("Failed to instantiate class: [" + userType + "] caused by" + " unsupported parameter: [" + parameter.getName() + "], only Application and Providers are" + " supported!");
        }
        try {
            return new ProxyComponent<Application>(object, (Application)constructor.newInstance(args));
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("Failed to instantiate class: [" + userType + "]", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate class: [" + userType + "]", ex);
        }
    }

    private static boolean isGlobalComponent(Set<Class<? extends Annotation>> appNameBindings, Object target) {
        Set<Class<? extends Annotation>> targetNameBindings = JaxrsUtils.findNameBindings(ClassUtils.getUserType((Object)target));
        return targetNameBindings.isEmpty() || appNameBindings.containsAll(targetNameBindings);
    }
}

