/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import io.esastack.restlight.core.handler.method.HandlerMethod;
import io.esastack.restlight.core.resolver.ResolverExecutor;
import io.esastack.restlight.core.resolver.ret.ReturnValueResolverContext;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverAdviceAdapter;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverContext;
import io.esastack.restlight.jaxrs.adapter.ProvidersPredicate;
import io.esastack.restlight.jaxrs.adapter.ResponseEntityStreamUtils;
import io.esastack.restlight.jaxrs.impl.ext.WriterInterceptorContextImpl;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.io.OutputStream;

public class WriterInterceptorsAdapter
implements ResponseEntityResolverAdviceAdapter {
    private final WriterInterceptor[] interceptors;
    private final ProvidersPredicate predicate;

    public WriterInterceptorsAdapter(WriterInterceptor[] interceptors, ProvidersPredicate predicate) {
        Checks.checkNotNull((Object)interceptors, (String)"interceptors");
        Checks.checkNotNull((Object)predicate, (String)"predicate");
        this.interceptors = interceptors;
        this.predicate = predicate;
    }

    public void aroundResolve0(ResolverExecutor<ResponseEntityResolverContext> executor) throws Exception {
        ReturnValueResolverContext context = (ReturnValueResolverContext)executor.context();
        if (this.predicate.test(context.requestContext())) {
            MultivaluedMap<String, Object> headers = JaxrsUtils.convertToMap(context.requestContext().response().headers());
            try {
                new WriterInterceptorContextImpl(executor, (OutputStream)ResponseEntityStreamUtils.getUnClosableOutputStream(context.requestContext()), headers, this.interceptors).proceed();
            }
            catch (Throwable th) {
                JaxrsUtils.convertThenAddToHeaders(headers, context.requestContext().response().headers());
                throw th;
            }
        } else {
            executor.proceed();
        }
    }

    public boolean supports(HandlerMethod method) {
        return true;
    }

    public boolean alsoApplyWhenMissingHandler() {
        return true;
    }
}

