/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.reflect.AnnotationUtils;
import io.esastack.restlight.core.resolver.converter.StringConverter;
import io.esastack.restlight.core.resolver.converter.StringConverterFactory;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;

public class StringConverterProviderAdapter
implements StringConverterFactory {
    private final ParamConverterProvider underlying;
    private final int order;

    public StringConverterProviderAdapter(ParamConverterProvider underlying, int order) {
        Checks.checkNotNull((Object)underlying, (String)"underlying");
        this.underlying = underlying;
        this.order = order;
    }

    public Optional<StringConverter> createConverter(StringConverterFactory.Key key) {
        final ParamConverter converter = this.underlying.getConverter(key.type(), key.genericType(), key.param().annotations());
        if (converter == null) {
            return Optional.empty();
        }
        final boolean isLazy = AnnotationUtils.hasAnnotation((AnnotatedElement)ClassUtils.getUserType((Object)converter), ParamConverter.Lazy.class);
        return Optional.of(new StringConverter(){

            public Object fromString(String value) {
                return converter.fromString(value);
            }

            public boolean isLazy() {
                return isLazy;
            }
        });
    }

    public int getOrder() {
        return this.order;
    }
}

