/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.collection.Attribute;
import esa.commons.collection.AttributeKey;
import esa.commons.io.IOUtils;
import io.esastack.restlight.core.context.HttpOutputStream;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.context.impl.HttpOutputStreamImpl;
import io.esastack.restlight.jaxrs.resolver.ResponseEntityStreamChannelImpl;
import java.io.Closeable;
import java.io.OutputStream;

final class ResponseEntityStreamUtils {
    private static final AttributeKey<HttpOutputStream> CLOSABLE_STREAM = AttributeKey.valueOf((String)"$closable.stream");

    static HttpOutputStream getUnClosableOutputStream(RequestContext context) {
        HttpOutputStream outputStream = ResponseEntityStreamChannelImpl.get(context).outputStream();
        Attribute attr = context.attrs().attr(CLOSABLE_STREAM);
        if (attr.get() == null) {
            attr.set((Object)outputStream);
            context.onEnd(ResponseEntityStreamUtils::close);
        }
        return new HttpOutputStreamImpl((OutputStream)outputStream){

            public void close() {
            }
        };
    }

    static void close(RequestContext context) {
        HttpOutputStream closable = (HttpOutputStream)context.attrs().attr(CLOSABLE_STREAM).getAndRemove();
        if (closable != null) {
            IOUtils.closeQuietly((Closeable)closable);
        }
    }

    private ResponseEntityStreamUtils() {
    }
}

