/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.filter.Filter;
import io.esastack.restlight.core.filter.FilterChain;
import io.esastack.restlight.core.filter.FilterContext;
import io.esastack.restlight.core.util.Futures;
import io.esastack.restlight.jaxrs.impl.JaxrsContextUtils;
import io.esastack.restlight.jaxrs.impl.container.AbstractContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.util.concurrent.CompletionStage;

public class PreMatchRequestFiltersAdapter
implements Filter {
    private final ContainerRequestFilter[] filters;

    public PreMatchRequestFiltersAdapter(ContainerRequestFilter[] filters) {
        Checks.checkNotNull((Object)filters, (String)"filters");
        this.filters = filters;
    }

    public CompletionStage<Void> doFilter(FilterContext context, FilterChain chain) {
        AbstractContainerRequestContext ctx = JaxrsContextUtils.getRequestContext((RequestContext)context);
        try {
            for (ContainerRequestFilter filter : this.filters) {
                filter.filter((ContainerRequestContext)ctx);
                if (!ctx.isAborted()) continue;
                return Futures.completedFuture();
            }
        }
        catch (Throwable th) {
            return Futures.completedExceptionally((Throwable)th);
        }
        return chain.doFilter(context);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

