/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.Result;
import io.esastack.commons.net.http.MediaType;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.context.ResponseEntity;
import io.esastack.restlight.core.handler.method.HandlerMethod;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverAdapter;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverContext;
import io.esastack.restlight.core.util.ResponseEntityUtils;
import io.esastack.restlight.jaxrs.adapter.ResponseEntityStreamUtils;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import io.esastack.restlight.jaxrs.util.MediaTypeUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.OutputStream;

public class MessageBodyWriterAdapter<T>
implements ResponseEntityResolverAdapter {
    private final Providers providers;

    public MessageBodyWriterAdapter(Providers providers) {
        Checks.checkNotNull((Object)providers, (String)"providers");
        this.providers = providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Void, Void> resolve(ResponseEntityResolverContext context) throws Exception {
        ResponseEntity entity = context.responseEntity();
        RequestContext requestContext = context.requestContext();
        if (entity.response().entity() == null) {
            return Result.err();
        }
        Class type = entity.type();
        if (type == null) {
            entity.type(ClassUtils.getUserType((Object)entity.response().entity()));
        }
        for (MediaType mediaType : ResponseEntityUtils.getMediaTypes((RequestContext)requestContext)) {
            jakarta.ws.rs.core.MediaType mediaType0 = MediaTypeUtils.convert(mediaType);
            MessageBodyWriter writer = this.providers.getMessageBodyWriter(entity.type(), entity.genericType(), entity.annotations(), mediaType0);
            if (writer == null) continue;
            Object value = entity.response().entity();
            MultivaluedMap<String, Object> headers = JaxrsUtils.convertToMap(requestContext.response().headers());
            try {
                writer.writeTo(value, entity.type(), entity.genericType(), entity.annotations(), mediaType0, headers, (OutputStream)ResponseEntityStreamUtils.getUnClosableOutputStream(requestContext));
            }
            finally {
                JaxrsUtils.convertThenAddToHeaders(headers, requestContext.response().headers());
            }
            ResponseEntityStreamUtils.close(requestContext);
            return Result.ok();
        }
        return Result.err();
    }

    public boolean supports(HandlerMethod method) {
        return true;
    }

    public boolean alsoApplyWhenMissingHandler() {
        return true;
    }

    public int getOrder() {
        return 90;
    }
}

