/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import esa.commons.Result;
import io.esastack.restlight.core.context.RequestEntity;
import io.esastack.restlight.core.handler.method.Param;
import io.esastack.restlight.core.resolver.param.entity.RequestEntityResolverAdapter;
import io.esastack.restlight.core.resolver.param.entity.RequestEntityResolverContext;
import io.esastack.restlight.jaxrs.impl.core.ModifiableMultivaluedMap;
import io.esastack.restlight.jaxrs.util.MediaTypeUtils;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Providers;
import java.io.InputStream;

public class MessageBodyReaderAdapter<T>
implements RequestEntityResolverAdapter {
    private final Providers providers;

    public MessageBodyReaderAdapter(Providers providers) {
        Checks.checkNotNull((Object)providers, (String)"providers");
        this.providers = providers;
    }

    public Result<?, Void> resolve(RequestEntityResolverContext context) throws Exception {
        RequestEntity entity = context.requestEntity();
        Class type = entity.type();
        if (type == null) {
            return Result.err();
        }
        MediaType mediaType = MediaTypeUtils.convert(entity.mediaType());
        MessageBodyReader reader = this.providers.getMessageBodyReader(type, entity.genericType(), entity.annotations(), mediaType);
        if (reader == null) {
            return Result.err();
        }
        Object value = reader.readFrom(type, entity.genericType(), entity.annotations(), mediaType, (MultivaluedMap)new ModifiableMultivaluedMap(context.requestContext().request().headers()), (InputStream)entity.inputStream());
        return Result.ok((Object)value);
    }

    public boolean supports(Param param) {
        return true;
    }

    public int getOrder() {
        return 90;
    }
}

