/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import esa.commons.collection.AttributeKey;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.filter.Filter;
import io.esastack.restlight.core.filter.FilterChain;
import io.esastack.restlight.core.filter.FilterContext;
import io.esastack.restlight.core.filter.RouteContext;
import io.esastack.restlight.core.filter.RouteFilter;
import io.esastack.restlight.core.filter.RouteFilterChain;
import io.esastack.restlight.core.handler.HandlerMapping;
import io.esastack.restlight.core.util.Futures;
import io.esastack.restlight.jaxrs.adapter.ResponseEntityStreamUtils;
import io.esastack.restlight.jaxrs.impl.JaxrsContextUtils;
import io.esastack.restlight.jaxrs.impl.container.ContainerResponseContextImpl;
import io.esastack.restlight.jaxrs.impl.container.ResponseContainerContext;
import io.esastack.restlight.jaxrs.impl.core.ResponseImpl;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.OutputStream;
import java.util.concurrent.CompletionStage;

public class JaxrsResponseFiltersAdapter
implements Filter {
    private static final AttributeKey<ContainerResponseFilter[]> HAS_BOUND_FILTERS = AttributeKey.valueOf((String)"$bound_filters");
    private final ContainerResponseFilter[] filters;

    public JaxrsResponseFiltersAdapter(ContainerResponseFilter[] filters) {
        Checks.checkNotNull((Object)filters, (String)"filters");
        this.filters = filters;
    }

    public CompletionStage<Void> doFilter(FilterContext context, FilterChain chain) {
        return chain.doFilter(context).thenCompose(v -> JaxrsResponseFiltersAdapter.applyResponseFilters((RequestContext)context, this.getBoundFilters((RequestContext)context)));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    ContainerResponseFilter[] getBoundFilters(RequestContext context) {
        ContainerResponseFilter[] bound = (ContainerResponseFilter[])context.attrs().attr(HAS_BOUND_FILTERS).getAndRemove();
        if (bound != null) {
            return bound;
        }
        return this.filters;
    }

    static CompletionStage<Void> applyResponseFilters(RequestContext context, ContainerResponseFilter[] filters) {
        if (!JaxrsResponseFiltersAdapter.isSuccess(context) || filters == null || filters.length == 0) {
            return Futures.completedFuture();
        }
        ResponseImpl rsp = JaxrsResponseFiltersAdapter.getResponse(context);
        JaxrsUtils.addMetadataToJakarta(context.response(), rsp);
        ResponseContainerContext reqCtx = new ResponseContainerContext(JaxrsContextUtils.getRequestContext(context));
        ContainerResponseContextImpl rspCtx = new ContainerResponseContextImpl((OutputStream)ResponseEntityStreamUtils.getUnClosableOutputStream(context), rsp);
        for (ContainerResponseFilter filter : filters) {
            try {
                filter.filter((ContainerRequestContext)reqCtx, (ContainerResponseContext)rspCtx);
            }
            catch (Throwable ex) {
                JaxrsUtils.addMetadataFromJakarta(rsp, context.response());
                return Futures.completedExceptionally((Throwable)ex);
            }
        }
        JaxrsUtils.addMetadataFromJakarta(rsp, context.response());
        return Futures.completedFuture();
    }

    static boolean isSuccess(RequestContext context) {
        return context.response().status() < 400;
    }

    static ResponseImpl getResponse(RequestContext context) {
        Response response = context.response().entity() instanceof Response ? (Response)context.response().entity() : null;
        ResponseImpl rsp = response == null ? (ResponseImpl)RuntimeDelegate.getInstance().createResponseBuilder().build() : (response instanceof ResponseImpl ? (ResponseImpl)response : (ResponseImpl)Response.fromResponse((Response)response).build());
        return rsp;
    }

    static class ContainerResponseFilterBinder
    implements RouteFilter {
        private final ContainerResponseFilter[] filters;

        ContainerResponseFilterBinder(ContainerResponseFilter[] filters) {
            this.filters = filters;
        }

        public CompletionStage<Void> routed(HandlerMapping mapping, RouteContext context, RouteFilterChain next) {
            context.attrs().attr(HAS_BOUND_FILTERS).set((Object)this.filters);
            return next.doNext(mapping, context);
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }
}

