/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.ClassUtils;
import io.esastack.restlight.core.handler.method.HandlerMethod;
import io.esastack.restlight.core.resolver.ResolverExecutor;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverAdviceAdapter;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverContext;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;

public class JaxrsResponseAdapter
implements ResponseEntityResolverAdviceAdapter {
    public void aroundResolve0(ResolverExecutor<ResponseEntityResolverContext> executor) throws Exception {
        ResponseEntityResolverContext context = (ResponseEntityResolverContext)executor.context();
        Object entity = context.requestContext().response().entity();
        if (entity == null) {
            executor.proceed();
            return;
        }
        if (entity instanceof GenericEntity) {
            GenericEntity gEntity = (GenericEntity)entity;
            entity = gEntity.getEntity();
            context.requestContext().response().entity(entity);
            context.responseEntity().type(gEntity.getRawType());
            context.responseEntity().genericType(gEntity.getType());
        }
        Response response = null;
        if (entity instanceof Response) {
            response = (Response)entity;
        } else if (entity instanceof Response.ResponseBuilder) {
            response = ((Response.ResponseBuilder)entity).build();
        }
        if (response != null) {
            this.adaptResponse(response, context);
        }
        executor.proceed();
    }

    public boolean supports(HandlerMethod method) {
        return true;
    }

    public boolean alsoApplyWhenMissingHandler() {
        return true;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private void adaptResponse(Response from, ResponseEntityResolverContext target) {
        Object entity = from.getEntity();
        if (entity != null) {
            target.requestContext().response().entity(entity);
            Class type = ClassUtils.getUserType((Object)entity);
            Class genericType = ClassUtils.getRawType((Type)type);
            target.responseEntity().type(type);
            target.responseEntity().genericType((Type)genericType);
        }
        target.requestContext().response().status(from.getStatus());
    }
}

