/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.resolver.exception.ExceptionResolver;
import io.esastack.restlight.core.util.Futures;
import io.esastack.restlight.jaxrs.configure.ProxyComponent;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.concurrent.CompletionStage;

public class JaxrsExceptionMapperAdapter<T extends Throwable>
implements ExceptionResolver<T> {
    private final ProxyComponent<ExceptionMapper<T>> underlying;

    public JaxrsExceptionMapperAdapter(ProxyComponent<ExceptionMapper<T>> underlying) {
        Checks.checkNotNull(underlying, (String)"underlying");
        this.underlying = underlying;
    }

    public CompletionStage<Void> handleException(RequestContext context, T t) {
        try {
            Response response = this.underlying.proxied().toResponse(t);
            if (response == null) {
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            context.response().entity((Object)response);
            return Futures.completedFuture();
        }
        catch (Throwable th) {
            return Futures.completedExceptionally((Throwable)th);
        }
    }

    public ProxyComponent<ExceptionMapper<T>> underlying() {
        return this.underlying;
    }
}

