/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import io.esastack.commons.net.http.MediaType;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.handler.method.Param;
import io.esastack.restlight.core.resolver.converter.StringConverterProvider;
import io.esastack.restlight.core.resolver.factory.HandlerResolverFactory;
import io.esastack.restlight.core.resolver.param.ParamResolver;
import io.esastack.restlight.core.resolver.param.ParamResolverContext;
import io.esastack.restlight.core.resolver.param.ParamResolverFactory;
import io.esastack.restlight.core.serialize.HttpRequestSerializer;
import io.esastack.restlight.core.util.ResponseEntityUtils;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import io.esastack.restlight.jaxrs.util.MediaTypeUtils;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import java.util.List;

public class JaxrsContextResolverFactory
implements ParamResolverFactory {
    private final Providers providers;

    public JaxrsContextResolverFactory(Providers providers) {
        Checks.checkNotNull((Object)providers, (String)"providers");
        this.providers = providers;
    }

    public ParamResolver<ParamResolverContext> createResolver(Param param, StringConverterProvider converters, List<? extends HttpRequestSerializer> serializers, HandlerResolverFactory resolverFactory) {
        return new JaxrsContextResolver(param, this.providers);
    }

    public boolean supports(Param param) {
        return JaxrsUtils.hasAnnotation(param, Context.class) && this.providers.getContextResolver(param.type(), jakarta.ws.rs.core.MediaType.WILDCARD_TYPE) != null;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static final class JaxrsContextResolver
    implements ParamResolver<ParamResolverContext> {
        private final Param param;
        private final Providers providers;

        private JaxrsContextResolver(Param param, Providers providers) {
            this.param = param;
            this.providers = providers;
        }

        public Object resolve(ParamResolverContext context) throws Exception {
            for (MediaType mediaType : ResponseEntityUtils.getMediaTypes((RequestContext)context.requestContext())) {
                ContextResolver resolver = this.providers.getContextResolver(this.param.type(), MediaTypeUtils.convert(mediaType));
                if (resolver == null) continue;
                return resolver.getContext(this.param.type());
            }
            return null;
        }
    }
}

