/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.adapter;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import io.esastack.restlight.core.DeployContext;
import io.esastack.restlight.core.deploy.ConfigurableHandler;
import io.esastack.restlight.core.deploy.HandlerConfigure;
import io.esastack.restlight.core.filter.RouteFilter;
import io.esastack.restlight.core.handler.method.HandlerMethod;
import io.esastack.restlight.core.resolver.context.ContextResolverAdapter;
import io.esastack.restlight.core.resolver.param.entity.RequestEntityResolverAdviceAdapter;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverAdviceAdapter;
import io.esastack.restlight.jaxrs.adapter.JaxrsResponseFiltersAdapter;
import io.esastack.restlight.jaxrs.adapter.PostMatchRequestFiltersAdapter;
import io.esastack.restlight.jaxrs.adapter.ProvidersPredicate;
import io.esastack.restlight.jaxrs.adapter.ReaderInterceptorsAdapter;
import io.esastack.restlight.jaxrs.adapter.WriterInterceptorsAdapter;
import io.esastack.restlight.jaxrs.configure.OrderComponent;
import io.esastack.restlight.jaxrs.configure.ProvidersFactoryImpl;
import io.esastack.restlight.jaxrs.configure.ProxyComponent;
import io.esastack.restlight.jaxrs.impl.container.DynamicFeatureContext;
import io.esastack.restlight.jaxrs.impl.container.ResourceInfoImpl;
import io.esastack.restlight.jaxrs.impl.core.ConfigurationImpl;
import io.esastack.restlight.jaxrs.impl.ext.ProvidersImpl;
import io.esastack.restlight.jaxrs.resolver.context.ConfigurationResolverAdapter;
import io.esastack.restlight.jaxrs.resolver.context.ProvidersResolverAdapter;
import io.esastack.restlight.jaxrs.util.JaxrsMappingUtils;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DynamicFeatureAdapter
implements HandlerConfigure {
    private final DeployContext context;
    private final Set<Class<? extends Annotation>> appNameBindings;
    private final Collection<ProxyComponent<DynamicFeature>> features;
    private final ConfigurationImpl parent;

    public DynamicFeatureAdapter(DeployContext context, Set<Class<? extends Annotation>> appNameBindings, Collection<ProxyComponent<DynamicFeature>> features, ConfigurationImpl parent) {
        Checks.checkNotNull((Object)context, (String)"context");
        Checks.checkNotNull((Object)parent, (String)"parent");
        this.context = context;
        this.appNameBindings = appNameBindings;
        this.features = features == null || features.isEmpty() ? Collections.emptyList() : Collections.unmodifiableCollection(features);
        this.parent = parent;
    }

    public void configure(HandlerMethod handlerMethod, ConfigurableHandler configurable) {
        ContainerResponseFilter[] filters;
        List writerInterceptors;
        ConfigurationImpl current = new ConfigurationImpl(this.parent);
        ResourceInfoImpl resourceInfo = new ResourceInfoImpl(handlerMethod.beanType(), handlerMethod.method());
        for (ProxyComponent<DynamicFeature> feature : this.features) {
            feature.proxied().configure((ResourceInfo)resourceInfo, (FeatureContext)new DynamicFeatureContext(ClassUtils.getUserType((Object)feature.underlying()), current));
        }
        ProvidersFactoryImpl providers = new ProvidersFactoryImpl(this.context, current);
        List readerInterceptors = this.filterByNameBindings(handlerMethod, providers.readerInterceptors(), false);
        if (!readerInterceptors.isEmpty()) {
            configurable.addRequestEntityResolverAdvice((RequestEntityResolverAdviceAdapter)new ReaderInterceptorsAdapter(JaxrsUtils.ascendingOrdered(readerInterceptors).toArray(new ReaderInterceptor[0]), ProvidersPredicate.BINDING_HANDLER));
        }
        if (!(writerInterceptors = this.filterByNameBindings(handlerMethod, providers.writerInterceptors(), false)).isEmpty()) {
            configurable.addResponseEntityResolverAdvice((ResponseEntityResolverAdviceAdapter)new WriterInterceptorsAdapter(JaxrsUtils.ascendingOrdered(writerInterceptors).toArray(new WriterInterceptor[0]), ProvidersPredicate.BINDING_HANDLER));
        }
        if (JaxrsMappingUtils.isMethod(handlerMethod.method()) && !(filters = this.filterByNameBindings(handlerMethod, providers.requestFilters(), true)).isEmpty()) {
            configurable.addRouteFilter((RouteFilter)new PostMatchRequestFiltersAdapter(JaxrsUtils.ascendingOrdered(filters).toArray(new ContainerRequestFilter[0])));
        }
        if (JaxrsMappingUtils.isMethod(handlerMethod.method())) {
            filters = JaxrsUtils.descendingOrder(this.filterByNameBindings(handlerMethod, providers.responseFilters(), false)).toArray(new ContainerResponseFilter[0]);
            configurable.addRouteFilter((RouteFilter)new JaxrsResponseFiltersAdapter.ContainerResponseFilterBinder(filters));
        }
        configurable.addContextResolver((ContextResolverAdapter)new ConfigurationResolverAdapter(current){

            @Override
            public int getOrder() {
                return 0;
            }
        });
        configurable.addContextResolver((ContextResolverAdapter)new ProvidersResolverAdapter(new ProvidersImpl(providers)){

            @Override
            public int getOrder() {
                return 0;
            }
        });
    }

    private <T> List<OrderComponent<T>> filterByNameBindings(HandlerMethod method, Collection<ProxyComponent<T>> components, boolean skipPreMatching) {
        if (components.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Class<? extends Annotation>> methodAnnotations = JaxrsUtils.findNameBindings(method.method(), true);
        LinkedList<OrderComponent<T>> bound = new LinkedList<OrderComponent<T>>();
        for (ProxyComponent<T> component : components) {
            Set<Class<? extends Annotation>> annotations;
            if (skipPreMatching && JaxrsUtils.isPreMatched(component.underlying()) || !this.appNameBindings.containsAll(annotations = JaxrsUtils.findNameBindings(ClassUtils.getUserType((Object)component.underlying()))) && !methodAnnotations.containsAll(annotations)) continue;
            bound.add(new OrderComponent<T>(component.proxied(), JaxrsUtils.getOrder(component.underlying())));
        }
        return bound;
    }
}

