/*
 * Decompiled with CFR 0.152.
 */
package esa.restlight.jaxrs.util;

import esa.commons.StringUtils;
import esa.commons.UrlUtils;
import esa.commons.reflect.AnnotationUtils;
import esa.restlight.core.method.Param;
import esa.restlight.core.util.ConverterUtils;
import esa.restlight.server.route.Mapping;
import esa.restlight.server.route.impl.MappingImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

public final class JaxrsMappingUtils {
    private JaxrsMappingUtils() {
    }

    public static String extractDefaultValue(Param parameter) {
        if (parameter == null) {
            return null;
        }
        DefaultValue defaultValueAnn = (DefaultValue)parameter.getAnnotation(DefaultValue.class);
        String defaultValue = null;
        if (defaultValueAnn != null) {
            defaultValue = defaultValueAnn.value();
        }
        return defaultValue;
    }

    public static Optional<Mapping> extractMapping(Class<?> userType, Method method) {
        return JaxrsMappingUtils.extractMapping(userType, method, StringUtils.empty());
    }

    public static Optional<Mapping> extractMapping(Class<?> userType, Method method, String contextPath) {
        if (method == null || userType == null) {
            return Optional.empty();
        }
        contextPath = ConverterUtils.standardContextPath((String)contextPath);
        String parentPath = JaxrsMappingUtils.getAnnotation(userType, Path.class).map(Path::value).orElse(null);
        String path = JaxrsMappingUtils.getAnnotation(method, Path.class).map(Path::value).orElse(null);
        String[] parentConsumes = JaxrsMappingUtils.getAnnotation(userType, Consumes.class).map(Consumes::value).orElse(null);
        String[] consumes = JaxrsMappingUtils.getAnnotation(method, Consumes.class).map(Consumes::value).orElse(null);
        String[] parentProduces = JaxrsMappingUtils.getAnnotation(userType, Produces.class).map(Produces::value).orElse(null);
        String[] produces = JaxrsMappingUtils.getAnnotation(method, Produces.class).map(Produces::value).orElse(null);
        String parentHttpMethod = JaxrsMappingUtils.getMethod(userType);
        String httpMethod = JaxrsMappingUtils.getMethod(method);
        if (parentPath == null && parentConsumes == null && parentProduces == null && parentHttpMethod == null) {
            if (path == null || httpMethod == null) {
                return Optional.empty();
            }
            return Optional.of(JaxrsMappingUtils.getMapping(contextPath, path, httpMethod, consumes, produces));
        }
        if (parentHttpMethod == null && httpMethod == null || parentPath == null && path == null) {
            return Optional.empty();
        }
        return Optional.of(JaxrsMappingUtils.getMapping(contextPath, parentPath, parentHttpMethod, parentConsumes, parentProduces).combine(JaxrsMappingUtils.getMapping(StringUtils.empty(), path, httpMethod, consumes, produces)));
    }

    private static String getMethod(AnnotatedElement element) {
        String method = JaxrsMappingUtils.getAnnotation(element, HttpMethod.class).map(HttpMethod::value).orElse(null);
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, GET.class).map(get -> "GET").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, POST.class).map(get -> "POST").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, PUT.class).map(get -> "PUT").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, DELETE.class).map(get -> "DELETE").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, PATCH.class).map(get -> "PATCH").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, OPTIONS.class).map(get -> "OPTIONS").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, HEAD.class).map(get -> "HEAD").orElse(null);
        }
        return method;
    }

    private static Mapping getMapping(String contextPath, String path, String httpMethod, String[] consumes, String[] produces) {
        String p = ConverterUtils.standardContextPath((String)contextPath) + StringUtils.emptyIfNull((String)UrlUtils.prependLeadingSlash((String)path));
        MappingImpl mapping = Mapping.mapping((String)p).consumes(consumes == null ? new String[]{} : consumes).produces(produces == null ? new String[]{} : produces);
        if (!StringUtils.isEmpty((String)httpMethod)) {
            mapping = mapping.method(httpMethod);
        }
        return mapping;
    }

    private static <A extends Annotation> Optional<A> getAnnotation(AnnotatedElement element, Class<A> targetClass) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((AnnotatedElement)element, targetClass));
    }
}

