/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.tools;

import io.esastack.cabin.common.util.FileUtils;
import io.esastack.cabin.loader.util.ArchiveUtils;
import io.esastack.cabin.tools.JarWriter;
import io.esastack.cabin.tools.Libraries;
import io.esastack.cabin.tools.Library;
import io.esastack.cabin.tools.LibraryScope;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.plugin.logging.Log;

public class Repackager {
    private static final String CABIN_VERSION_ATTRIBUTE = "Cabin-Version";
    private static final String CABIN_CONTAINER_ROOT = "Cabin-Container-Root";
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private final File source;
    private final Log logger;
    private final List<Library> moduleLibraries = new ArrayList<Library>();
    private final List<Library> bizLibraries = new ArrayList<Library>();
    private String startClass;
    private File executableFatJar;
    private File baseDir;
    private boolean packageProvided;
    private String cabinVersion;
    private Library containerLibrary;

    public Repackager(File source, Log logger) {
        if (source == null || logger == null) {
            throw new IllegalArgumentException("Source file must be provided");
        }
        if (!source.exists() || !source.isFile()) {
            throw new IllegalArgumentException("Source must refer to an existing file, got" + source.getAbsolutePath());
        }
        this.source = source.getAbsoluteFile();
        this.logger = logger;
    }

    public static boolean isZip(File file) {
        boolean bl;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            bl = Repackager.isZip(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    public static boolean isZip(InputStream inputStream) throws IOException {
        for (int i = 0; i < ZIP_FILE_HEADER.length; ++i) {
            if (inputStream.read() == ZIP_FILE_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    public void setCabinVersion(String cabinVersion) {
        this.cabinVersion = cabinVersion;
    }

    public void setStartClass(String startClass) {
        this.startClass = startClass;
    }

    public void repackage(File appDestination, Libraries libraries) throws IOException {
        if (appDestination == null || appDestination.isDirectory()) {
            throw new IllegalArgumentException("Invalid destination");
        }
        if (libraries == null) {
            throw new IllegalArgumentException("Libraries must not be null");
        }
        if (this.alreadyRepackaged()) {
            return;
        }
        this.executableFatJar = appDestination;
        libraries.doWithLibraries(library -> {
            if (LibraryScope.PROVIDED.equals(library.getScope()) && !this.isPackageProvided()) {
                this.logger.debug((CharSequence)("Ignore provided library: " + library.getFile()));
                return;
            }
            if (!Repackager.isZip(library.getFile())) {
                this.logger.debug((CharSequence)("Ignore none zip library: " + library.getFile()));
                return;
            }
            try (JarFile jarFile = new JarFile(library.getFile());){
                if (ArchiveUtils.isCabinContainerJar((JarFile)jarFile)) {
                    this.logger.debug((CharSequence)("Found cabin core library: " + library.getFile()));
                    if (this.containerLibrary != null) {
                        throw new RuntimeException(String.format("Duplicate cabin-core dependency found, %s and %s", this.containerLibrary.getFile().getAbsolutePath(), library.getFile().getAbsolutePath()));
                    }
                    library.setScope(LibraryScope.CONTAINER);
                    this.containerLibrary = library;
                } else if (ArchiveUtils.isCabinModuleJar((JarFile)jarFile)) {
                    this.logger.debug((CharSequence)("Found cabin module library: " + library.getFile()));
                    library.setScope(LibraryScope.MODULE);
                    this.moduleLibraries.add(library);
                } else {
                    this.logger.debug((CharSequence)("Found biz library: " + library.getFile()));
                    this.bizLibraries.add(library);
                }
            }
            catch (Exception e) {
                this.logger.error((CharSequence)("Error while check jar type of " + library.getFile()), (Throwable)e);
            }
        });
        this.repackageApp();
    }

    private void repackageApp() throws IOException {
        File destination = this.executableFatJar.getAbsoluteFile();
        if (destination.exists()) {
            destination.delete();
        }
        try (JarWriter writer = new JarWriter(destination);){
            try (JarFile bizSource = new JarFile(this.source);){
                Manifest manifest = this.buildAppManifest(bizSource);
                writer.writeManifest(manifest);
                writer.writeEntries(bizSource, new RenamingEntryTransformer("APP-INF/classes/"));
                this.writeNestedLibraries(this.bizLibraries, "APP-INF/libs/", writer);
            }
            try (JarFile containerSource = new JarFile(this.containerLibrary.getFile().getAbsoluteFile());){
                this.writeConfigFiles(new File(this.baseDir, "conf/"), writer);
                writer.writeBootstrapEntry(containerSource);
                this.writeNestedLibraries(Collections.singletonList(this.containerLibrary), "ESA-CABIN/core/", writer);
                this.writeNestedLibraries(this.moduleLibraries, "ESA-CABIN/modules/", writer);
            }
        }
    }

    private void writeConfigFiles(File confDir, JarWriter jarWriter) throws IOException {
        File[] subFiles;
        if (confDir.exists() && (subFiles = confDir.listFiles()) != null && subFiles.length != 0) {
            for (File subFile : subFiles) {
                if (subFile.isDirectory()) {
                    this.writeConfigFiles(subFile, jarWriter);
                    continue;
                }
                int index = this.baseDir.getPath().length();
                String entryName = subFile.getPath().substring(index);
                if (entryName.startsWith(File.separator)) {
                    entryName = entryName.substring(1);
                }
                jarWriter.writeEntry(FileUtils.getCompatiblePath((String)entryName), new FileInputStream(subFile));
            }
        }
    }

    private void writeNestedLibraries(List<Library> libraries, String destination, JarWriter writer) throws IOException {
        HashSet<String> writeLibs = new HashSet<String>();
        for (Library library : libraries) {
            String libPath = destination + library.getName();
            if (writeLibs.contains(libPath)) {
                throw new IllegalStateException("Duplicate library " + library.getName());
            }
            writeLibs.add(libPath);
            writer.writeNestedLibrary(destination, library);
        }
    }

    private Manifest buildAppManifest(JarFile source) throws IOException {
        Manifest manifest = source.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        }
        manifest = new Manifest(manifest);
        manifest.getMainAttributes().putValue("Main-Class", "io.esastack.cabin.support.boot.launcher.CabinJarLauncher");
        manifest.getMainAttributes().putValue("Start-Class", this.startClass);
        this.logger.debug((CharSequence)"MainClass: io.esastack.cabin.support.boot.launcher.CabinJarLauncher");
        this.logger.debug((CharSequence)("StartClass: " + this.startClass));
        if (this.cabinVersion == null || this.cabinVersion.isEmpty()) {
            throw new IllegalStateException("must specify version of Cabin.");
        }
        manifest.getMainAttributes().putValue(CABIN_VERSION_ATTRIBUTE, this.cabinVersion);
        manifest.getMainAttributes().putValue(CABIN_CONTAINER_ROOT, "ESA-CABIN/core/");
        return manifest;
    }

    private boolean alreadyRepackaged() throws IOException {
        try (JarFile jarFile = new JarFile(this.source);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest != null && manifest.getMainAttributes().getValue(CABIN_VERSION_ATTRIBUTE) != null;
            return bl;
        }
    }

    public boolean isPackageProvided() {
        return this.packageProvided;
    }

    public void setPackageProvided(boolean packageProvided) {
        this.packageProvided = packageProvided;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    private static final class RenamingEntryTransformer
    implements JarWriter.EntryTransformer {
        private final String namePrefix;

        private RenamingEntryTransformer(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public JarEntry transform(JarEntry entry) {
            JarEntry renamedEntry = new JarEntry(this.namePrefix + entry.getName());
            renamedEntry.setTime(entry.getTime());
            renamedEntry.setSize(entry.getSize());
            renamedEntry.setMethod(entry.getMethod());
            if (entry.getComment() != null) {
                renamedEntry.setComment(entry.getComment());
            }
            renamedEntry.setCompressedSize(entry.getCompressedSize());
            renamedEntry.setCrc(entry.getCrc());
            if (entry.getExtra() != null) {
                renamedEntry.setExtra(entry.getExtra());
            }
            return renamedEntry;
        }
    }
}

