/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.tools;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;

public class ArtifactPojo {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;

    public static ArtifactPojo extractArtifactPojo(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Format should not be empty!");
        }
        String[] arr = StringUtils.split((String)format, (String)":");
        if (arr.length < 2 || arr.length > 3) {
            throw new IllegalArgumentException(String.format("Invalid artifact format: %s", format));
        }
        ArtifactPojo pojo = new ArtifactPojo();
        pojo.setGroupId(arr[0]);
        pojo.setArtifactId(arr[1]);
        if (arr.length == 3) {
            pojo.setClassifier(arr[2]);
        }
        return pojo;
    }

    public static ArtifactPojo extractArtifactPojo(Artifact artifact) {
        ArtifactPojo pojo = new ArtifactPojo();
        pojo.setGroupId(artifact.getGroupId());
        pojo.setArtifactId(artifact.getArtifactId());
        pojo.setClassifier(artifact.getClassifier());
        pojo.setVersion(artifact.getVersion());
        return pojo;
    }

    public boolean isSameArtifact(ArtifactPojo pojo) {
        if (pojo == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getGroupId(), (CharSequence)pojo.getGroupId()) && StringUtils.equals((CharSequence)this.getArtifactId(), (CharSequence)pojo.getArtifactId()) && StringUtils.equals((CharSequence)this.getClassifier(), (CharSequence)pojo.getClassifier());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", this.groupId, this.artifactId, this.classifier, this.version);
    }
}

