/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.support.bootstrap.thread;

import java.lang.reflect.Method;

public class ReLaunchRunner
implements Runnable {
    private final String bootClazz;
    private final String bootMethod;
    private final String mainClass;
    private final String[] args;

    public ReLaunchRunner(String bootClazz, String bootMethod, String mainClass, String[] args) {
        this.bootClazz = bootClazz;
        this.bootMethod = bootMethod;
        this.mainClass = mainClass;
        this.args = args;
    }

    public static void join(ThreadGroup threadGroup) {
        boolean hasNonDaemonThreads;
        do {
            hasNonDaemonThreads = false;
            Thread[] threads = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threads);
            for (Thread thread : threads) {
                if (thread == null || thread.isDaemon()) continue;
                try {
                    hasNonDaemonThreads = true;
                    thread.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (hasNonDaemonThreads);
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            Class<?> startClass = classLoader.loadClass(this.bootClazz);
            Method entryMethod = startClass.getDeclaredMethod(this.bootMethod, String.class, String[].class);
            entryMethod.setAccessible(true);
            entryMethod.invoke(null, this.mainClass, this.args);
        }
        catch (NoSuchMethodException ex) {
            Exception wrappedEx = new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", ex);
            thread.getThreadGroup().uncaughtException(thread, wrappedEx);
        }
        catch (Throwable ex) {
            thread.getThreadGroup().uncaughtException(thread, ex);
        }
    }
}

