/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.support.bootstrap;

import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.loader.archive.Archive;
import io.esastack.cabin.loader.archive.JarFileArchive;
import io.esastack.cabin.loader.util.ArchiveUtils;
import io.esastack.cabin.support.boot.launcher.AbstractLauncher;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.jar.JarFile;

public class CabinClasspathLauncher
extends AbstractLauncher {
    private final String mainClass;
    private final URL[] classpathUrls;
    private final String containerUrl;
    private final String[] moduleUrls;

    public CabinClasspathLauncher(String mainClass, URL[] urls) {
        this.mainClass = mainClass;
        this.classpathUrls = urls;
        this.containerUrl = this.findContainerUrl();
        this.moduleUrls = this.findModuleURLs();
    }

    protected Object createCabinContainer(Class<?> cabinContainerClass) throws Exception {
        return cabinContainerClass.getConstructor(String.class, String[].class, String[].class, String[].class, String[].class).newInstance(this.containerUrl, this.moduleUrls, this.findBizUrls(), this.findJavaAgentUrls(), this.arguments);
    }

    protected String findAppMainClass() {
        return this.mainClass;
    }

    protected Archive findContainerArchive() throws Exception {
        return new JarFileArchive(new File(new URL(this.containerUrl).getFile()));
    }

    protected boolean lazyLoadExportClass() {
        return true;
    }

    private String findContainerUrl() {
        ArrayList<String> containerUrls = new ArrayList<String>();
        try {
            for (URL url : this.classpathUrls) {
                String path = this.getDecodedPath(url.getFile());
                if (!path.endsWith(".jar")) continue;
                try (JarFile jarFile = new JarFile(path);){
                    if (!ArchiveUtils.isCabinContainerJar((JarFile)jarFile)) continue;
                    containerUrls.add(this.getDecodedPath(url.toExternalForm()));
                }
            }
        }
        catch (Throwable t) {
            throw new CabinRuntimeException("Failed to find Cabin container Jar File", t);
        }
        if (containerUrls.size() == 0) {
            throw new CabinRuntimeException("No Cabin container Jar File found in classpath urls");
        }
        if (containerUrls.size() > 1) {
            throw new CabinRuntimeException("Multiple Cabin container Jar Files found in classpath urls");
        }
        return (String)containerUrls.get(0);
    }

    private String[] findModuleURLs() {
        ArrayList<String> filteredUrls = new ArrayList<String>();
        try {
            for (URL url : this.classpathUrls) {
                String path = this.getDecodedPath(url.getFile());
                if (!path.endsWith(".jar")) continue;
                try (JarFile jarFile = new JarFile(path);){
                    if (!ArchiveUtils.isCabinModuleJar((JarFile)jarFile)) continue;
                    filteredUrls.add(this.getDecodedPath(url.toExternalForm()));
                }
            }
        }
        catch (Throwable t) {
            throw new CabinRuntimeException("Failed tp find Cabin container Jar File", t);
        }
        return filteredUrls.toArray(new String[0]);
    }

    private String[] findBizUrls() throws Exception {
        ArrayList<String> filteredUrls = new ArrayList<String>();
        for (URL url : this.classpathUrls) {
            String urlString = this.getDecodedPath(url.toExternalForm());
            if (this.containerUrl.equals(urlString)) continue;
            boolean matched = false;
            for (String moduleUrl : this.moduleUrls) {
                if (!moduleUrl.equals(urlString)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                for (URL agentUrl : this.agentUrls) {
                    if (!this.getDecodedPath(agentUrl.toExternalForm()).equals(urlString)) continue;
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            filteredUrls.add(urlString);
        }
        return filteredUrls.toArray(new String[0]);
    }

    private String getDecodedPath(String path) throws UnsupportedEncodingException {
        return URLDecoder.decode(path, "UTF-8");
    }
}

