/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.support.bootstrap;

import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.util.ClassLoaderUtils;
import io.esastack.cabin.common.util.RelaunchMarkUtil;
import io.esastack.cabin.support.bootstrap.CabinClasspathLauncher;
import io.esastack.cabin.support.bootstrap.thread.IsolatedThreadGroup;
import io.esastack.cabin.support.bootstrap.thread.ReLaunchRunner;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CabinAppBootstrap {
    private static final String REBOOT_METHOD_NAME = "reboot";
    private static final String REBOOT_THREAD_NAME = "main";

    public static void run(String[] args) {
        if (args == null) {
            throw new CabinRuntimeException("args should not be null");
        }
        if (!RelaunchMarkUtil.isRelaunched()) {
            String mainClass = CabinAppBootstrap.deduceMainClass();
            String bootClazz = CabinAppBootstrap.class.getName();
            IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(bootClazz);
            ReLaunchRunner runner = new ReLaunchRunner(bootClazz, REBOOT_METHOD_NAME, mainClass, args);
            Thread rebootThread = new Thread(threadGroup, runner, REBOOT_THREAD_NAME);
            rebootThread.start();
            ReLaunchRunner.join(threadGroup);
            threadGroup.rethrowUncaughtException();
            System.exit(0);
        }
    }

    private static void reboot(String mainClass, String[] args) throws Exception {
        new CabinClasspathLauncher(mainClass, ClassLoaderUtils.getApplicationClassPaths()).launch(args);
    }

    private static String deduceMainClass() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!REBOOT_THREAD_NAME.equals(element.getMethodName())) continue;
            try {
                String mainClazz = element.getClassName();
                Class<?> mainClass = Class.forName(mainClazz, false, ClassLoaderUtils.getTCCL());
                Method method = mainClass.getDeclaredMethod(REBOOT_THREAD_NAME, String[].class);
                if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
                return mainClazz;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        throw new IllegalStateException("Unable to find main class");
    }
}

