/*
 * Decompiled with CFR 0.152.
 */
package io.epirus.web3j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class EpirusAccount {
    private static final Path EPIRUS_CONFIG_PATH = Paths.get(System.getProperty("user.home"), ".epirus", ".config");

    public static String getEpirusLoginToken() throws IOException {
        return System.getenv().getOrDefault("EPIRUS_LOGIN_TOKEN", EpirusAccount.getConfigFileLoginToken());
    }

    private static String getConfigFileLoginToken() throws IOException {
        if (!EPIRUS_CONFIG_PATH.toFile().exists() || System.getenv("EPIRUS_LOGIN_TOKEN") != null) {
            return null;
        }
        String configContents = new String(Files.readAllBytes(EPIRUS_CONFIG_PATH));
        ObjectNode node = (ObjectNode)new ObjectMapper().readValue(configContents, ObjectNode.class);
        if (node.has("loginToken")) {
            return node.get("loginToken").asText();
        }
        throw new IllegalStateException("Epirus config file exists but does not contain a login token. Please log in to the Epirus platform using the CLI.");
    }
}

