/*
 * Decompiled with CFR 0.152.
 */
package io.epirus.web3j;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.epirus.web3j.Epirus;
import io.epirus.web3j.EpirusHttpServiceProvider;
import io.epirus.web3j.HttpMockedTest;
import okhttp3.OkHttpClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.web3j.protocol.Network;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.http.HttpService;

public class EpirusHttpTest
extends HttpMockedTest {
    @Test
    public void testHttpServiceEnvironmentVariable() throws Exception {
        SystemLambda.withEnvironmentVariable((String)"EPIRUS_LOGIN_TOKEN", (String)"token").and("EPIRUS_APP_URL", "http://localhost:8000").execute(() -> {
            HttpService service = EpirusHttpServiceProvider.getEpirusHttpService((Network)Network.RINKEBY, (OkHttpClient)EpirusHttpServiceProvider.createOkHttpClientBuilder().build());
            Assertions.assertEquals((Object)"http://localhost:8000/api/rpc/rinkeby/token/", (Object)service.getUrl());
        });
    }

    @Test
    public void testEpirusPlatformWorksAgainstMock() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/api/rpc/mainnet/token/")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"id\":67,\n  \"jsonrpc\":\"2.0\",\n  \"result\": \"Mist/v0.9.3/darwin/go1.4.1\"\n}")));
        SystemLambda.withEnvironmentVariable((String)"EPIRUS_LOGIN_TOKEN", (String)"token").and("EPIRUS_APP_URL", wireMockServer.baseUrl()).execute(() -> {
            Web3j web3j = Epirus.buildWeb3j();
            String netVersion = ((Web3ClientVersion)web3j.web3ClientVersion().send()).getWeb3ClientVersion();
            Assertions.assertEquals((Object)"Mist/v0.9.3/darwin/go1.4.1", (Object)netVersion);
        });
    }

    @Test
    @Disabled(value="requires the CLI to be logged in to pass")
    public void testEpirusPlatformWorksAgainstProd() throws Exception {
        Web3j web3j = Epirus.buildWeb3j();
        String netVersion = ((EthBlock)web3j.ethGetBlockByNumber(DefaultBlockParameter.valueOf((String)"latest"), false).send()).getBlock().getHash();
        Assertions.assertTrue((netVersion.length() > 0 ? 1 : 0) != 0);
    }
}

