/*
 * Decompiled with CFR 0.152.
 */
package io.epirus.web3j.gas;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.epirus.web3j.EpirusAccount;
import io.epirus.web3j.gas.GasPrice;
import io.epirus.web3j.gas.GasPriceOracleResult;
import java.io.IOException;
import java.math.BigInteger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.web3j.protocol.Network;
import org.web3j.tx.gas.DefaultGasProvider;

public class EpirusGasProvider
extends DefaultGasProvider {
    private BigInteger gasPrice;
    private static final OkHttpClient client = new OkHttpClient();

    public EpirusGasProvider(Network network, GasPrice desiredGasPrice) throws IOException {
        this(network, String.format("https://%s.api.epirus.io/gas/price", network.getNetworkName().toLowerCase()), desiredGasPrice);
    }

    protected EpirusGasProvider(Network network, String url, GasPrice desiredGasPrice) throws IOException {
        if (!network.equals((Object)Network.RINKEBY) && !network.equals((Object)Network.ROPSTEN)) {
            this.gasPrice = GAS_PRICE;
            return;
        }
        String authToken = EpirusAccount.getEpirusLoginToken();
        Request request = new Request.Builder().url(url).get().addHeader("Authorization", "Bearer " + authToken).build();
        Response response = client.newCall(request).execute();
        if (response.code() != 200) {
            this.gasPrice = GAS_PRICE;
            return;
        }
        ResponseBody body = response.body();
        if (body != null) {
            GasPriceOracleResult result = (GasPriceOracleResult)new ObjectMapper().readValue(body.string(), GasPriceOracleResult.class);
            this.gasPrice = result.getDesiredGasPrice(desiredGasPrice);
        }
    }

    public BigInteger getGasPrice(String contractFunc) {
        return this.gasPrice;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }
}

