/*
 * Decompiled with CFR 0.152.
 */
package io.epirus.web3j;

import io.epirus.web3j.EpirusAccount;
import org.web3j.protocol.Network;
import org.web3j.protocol.http.HttpService;

public class EpirusHttpServiceProvider {
    public static HttpService getEpirusHttpService(Network network) throws Exception {
        String loginToken = EpirusAccount.getEpirusLoginToken();
        if (loginToken == null) {
            throw new IllegalStateException("Could not read your Epirus login token. In order to use Web3j without a specified endpoint, you must use the Epirus CLI and log in to the Epirus Platform.");
        }
        return EpirusHttpServiceProvider.createHttpServiceWithToken(network, loginToken);
    }

    private static HttpService createHttpServiceWithToken(Network network, String token) {
        String epirusBaseUrl = System.getenv().getOrDefault("EPIRUS_APP_URL", "https://portal.epirus.io");
        String httpEndpoint = String.format("%s/api/rpc/%s/%s/", epirusBaseUrl, network.getNetworkName(), token);
        return new HttpService(httpEndpoint);
    }
}

