/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.yosart.plugin.redis;

import io.enoa.nosql.redis.Redis;
import io.enoa.nosql.redis.RedisConfig;
import io.enoa.nosql.redis.RedisSentinelConfig;
import io.enoa.serialization.EoSerializationFactory;
import io.enoa.yosart.YoPlugin;
import io.enoa.yosart.thr.OyPluginException;

public class RedisPlugin
implements YoPlugin {
    private static final String DEF_NAME = "main";
    private RedisConfig config;
    private RedisSentinelConfig sentinel;
    private EoSerializationFactory serialization;

    public RedisPlugin(RedisConfig config) {
        this.config = config;
    }

    public RedisPlugin(RedisSentinelConfig sentinel) {
        this.sentinel = sentinel;
    }

    public RedisPlugin(String name, String host, int port, String passwd, EoSerializationFactory serialization) {
        this(new RedisConfig.Builder().name(name).host(host).port(port).passwd(passwd).build());
        this.serialization = serialization;
    }

    public RedisPlugin(String name, String host, int port, EoSerializationFactory serialization) {
        this(name, host, port, null, serialization);
    }

    public RedisPlugin(String name, String host, EoSerializationFactory serialization) {
        this(name, host, 6379, null, serialization);
    }

    public RedisPlugin(String name, String host, int port, String passwd) {
        this(name, host, port, passwd, null);
    }

    public RedisPlugin(String name, String host, int port) {
        this(name, host, port, null, null);
    }

    public RedisPlugin(String name, String host) {
        this(name, host, 6379, null, null);
    }

    public RedisPlugin(String host, int port, String passwd, EoSerializationFactory serialization) {
        this(DEF_NAME, host, port, passwd, serialization);
    }

    public RedisPlugin(String host, int port, EoSerializationFactory serialization) {
        this(DEF_NAME, host, port, null, serialization);
    }

    public RedisPlugin(String host, EoSerializationFactory serialization) {
        this(DEF_NAME, host, 6379, null, serialization);
    }

    public RedisPlugin(String host, int port, String passwd) {
        this(DEF_NAME, host, port, passwd, null);
    }

    public RedisPlugin(String host, int port) {
        this(DEF_NAME, host, port, null, null);
    }

    public RedisPlugin(String host) {
        this(DEF_NAME, host, 6379, null, null);
    }

    public String name() {
        return "RedisPlugin";
    }

    public String version() {
        return "1";
    }

    public String description() {
        return "Redis operate";
    }

    public boolean start() throws OyPluginException {
        if (this.config != null) {
            Redis.epm().install(this.config, this.serialization);
            return true;
        }
        if (this.sentinel != null) {
            Redis.epm().install(this.sentinel, this.serialization);
            return true;
        }
        return false;
    }

    public boolean stop() throws OyPluginException {
        String name = this.redisName();
        if (name == null) {
            return false;
        }
        Redis.epm().uninstall(name);
        return true;
    }

    public String redisName() {
        String name = null;
        if (this.config != null) {
            name = this.config.name();
        }
        if (this.sentinel != null) {
            name = this.sentinel.name();
        }
        return name;
    }
}

