/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.provider.netty.ts;

import io.enoa.repeater.EoxConfig;
import io.enoa.repeater.Repeater;
import io.enoa.repeater.factory.name.EoxNameRuleFactory;
import io.enoa.repeater.factory.ts.RepeaterTranslateFactory;
import io.enoa.repeater.http.Cookie;
import io.enoa.repeater.http.Request;
import io.enoa.repeater.http.Response;
import io.enoa.repeater.provider.netty.server.plus._RepeaterNettyRequest;
import io.enoa.repeater.provider.netty.ts.NettyCosRequestWrapper;
import io.enoa.repeater.provider.netty.ts.NettyRequestWrapper;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.thr.EoException;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;

public class NettyTranslateProvider
implements RepeaterTranslateFactory<_RepeaterNettyRequest, FullHttpResponse> {
    public Request request(EoxConfig config, EoxNameRuleFactory rule, _RepeaterNettyRequest oreq) {
        String vendor;
        switch (vendor = config.other().string("provider.netty.upload.vendor", "default")) {
            case "cos": {
                return new NettyCosRequestWrapper(oreq, Repeater.config(), rule);
            }
            case "common-upload": {
                throw new EoException("Can not support now.", new Object[0]);
            }
        }
        return new NettyRequestWrapper(oreq, Repeater.config(), rule);
    }

    public FullHttpResponse response(EoxConfig config, FullHttpResponse oresp, Response resp) {
        oresp.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)oresp.content().readableBytes());
        resp.headers().stream().filter(h -> !h.name().equalsIgnoreCase("content-length")).forEach(h -> oresp.headers().set(h.name(), (Object)h.value()));
        if (resp.headers().stream().noneMatch(h -> h.name().equalsIgnoreCase("content-type"))) {
            oresp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)resp.contentType());
        }
        if (CollectionKit.isEmpty((Object[])resp.cookies()).booleanValue()) {
            return oresp;
        }
        for (Cookie cookie : resp.cookies()) {
            oresp.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)cookie.toString());
        }
        return oresp;
    }
}

