/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.provider.netty.ts;

import io.enoa.repeater.EoxConfig;
import io.enoa.repeater.factory.http.EoxAbstractRequest;
import io.enoa.repeater.factory.name.EoxNameRuleFactory;
import io.enoa.repeater.http.Cookie;
import io.enoa.repeater.http.Method;
import io.enoa.repeater.http.Request;
import io.enoa.repeater.http.RequestBody;
import io.enoa.repeater.http.UFile;
import io.enoa.repeater.kit.http.EnoaHttpKit;
import io.enoa.repeater.provider.netty.server.plus._RepeaterNettyRequest;
import io.enoa.repeater.provider.netty.ts.NettyParser;
import io.enoa.toolkit.alg.UnitConvKit;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.convert.ConvertKit;
import io.enoa.toolkit.file.FileKit;
import io.enoa.toolkit.stream.StreamKit;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.thr.EoException;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class NettyRequestWrapper
extends EoxAbstractRequest {
    private static final HttpDataFactory factory = new DefaultHttpDataFactory(true);
    private _RepeaterNettyRequest request;
    private ByteBufInputStream inputStream;
    private EoxConfig config;
    private Map<String, List<String>> binparas = new HashMap<String, List<String>>();
    private List<UFile> ufiles = new ArrayList<UFile>();
    private Map<String, String[]> paraMap;
    private Cookie[] cookies;
    private RequestBody body;

    NettyRequestWrapper(_RepeaterNettyRequest request, EoxConfig config, EoxNameRuleFactory rule) {
        this.request = request;
        this.config = config;
        this.inputStream = new ByteBufInputStream(request.content());
        String contentType = this.header("content-type");
        if (TextKit.blankn((String)contentType)) {
            contentType = contentType.toLowerCase();
        }
        if (TextKit.blankn((String)contentType) && contentType.startsWith("multipart/form-data")) {
            String clength = this.header("content-length");
            Long contentLength = Long.parseLong(clength);
            if (contentLength > UnitConvKit.convert((long)config.maxUploadSize(), (UnitConvKit.Unit)UnitConvKit.Unit.MB, (UnitConvKit.Unit)UnitConvKit.Unit.BYTE)) {
                throw new EoException("Posted content length of {0} exceeds limit of {1}", new Object[]{contentLength, this.config.maxUploadSize()});
            }
            HttpPostRequestDecoder decoder = this.decoder();
            List datas = decoder.getBodyHttpDatas();
            FileKit.mkdirs((Path)this.config.tmp());
            NettyParser.ParseRet parseRet = NettyParser.parsePostData(datas, this.config, rule);
            this.binparas.putAll(parseRet.paras());
            this.ufiles.addAll(parseRet.ufiles());
            parseRet.clear();
            decoder.cleanFiles();
        }
    }

    private HttpPostRequestDecoder decoder() {
        return new HttpPostRequestDecoder(factory, (HttpRequest)this.request, this.config.charset());
    }

    public Object originRequest() {
        return this.request.originRequest();
    }

    public Method method() {
        Method method = Method.of((String)this.header("X-HTTP-Method-Override"));
        return method == null ? Method.of((String)this.request.method().name()) : method;
    }

    public String context() {
        return this.request.context();
    }

    public String uri() {
        String uri = this.request.uri();
        String[] uris = uri.split("\\?");
        return uris[0];
    }

    public String url() {
        return this.request.uri();
    }

    public RequestBody body() {
        if (this.body != null) {
            return this.body;
        }
        String contentType = this.header("content-type");
        if (TextKit.blankn((String)contentType)) {
            contentType = contentType.toLowerCase();
        }
        if (TextKit.blankn((String)contentType) && contentType.startsWith("multipart/form-data")) {
            return null;
        }
        try {
            byte[] binary = StreamKit.bytes((InputStream)this.inputStream);
            this.body = RequestBody.create((byte[])binary, (Charset)this.config.charset());
            return this.body;
        }
        catch (IOException e) {
            throw new EoException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public Cookie[] cookies() {
        if (this.cookies == null) {
            this.cookies = NettyParser.parseCookies(this.header("Cookie"));
        }
        return this.cookies;
    }

    public Cookie cookieObject(String name) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = this.cookies()) {
            if (!cookie.name().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public String cookie(String name, String def) {
        Cookie cookie = this.cookieObject(name);
        return cookie == null ? def : cookie.value();
    }

    public Integer cookieToInt(String name, Integer def) {
        String cookie = this.cookie(name);
        return ConvertKit.integer((String)cookie, (Integer)def);
    }

    public Long cookieToLong(String name, Long def) {
        String cookie = this.cookie(name);
        return ConvertKit.longer((String)cookie, (Long)def);
    }

    public String[] headerNames() {
        HttpHeaders headers = this.request.headers();
        Set names = headers.names();
        return names.toArray(new String[names.size()]);
    }

    public String header(String name) {
        String[] headerNames;
        for (String n : headerNames = this.headerNames()) {
            if (!n.equalsIgnoreCase(name.toLowerCase())) continue;
            return this.request.headers().get(n);
        }
        return null;
    }

    public String para(String name, String def) {
        Object[] paras = this.paraValues(name);
        if (CollectionKit.isEmpty((Object[])paras).booleanValue()) {
            return def;
        }
        return ConvertKit.string((Object)paras[0], (String)def, (boolean)Boolean.TRUE);
    }

    public Integer paraToInt(String name, Integer def) {
        return ConvertKit.integer((String)this.para(name), (Integer)def);
    }

    public Long paraToLong(String name, Long def) {
        return ConvertKit.longer((String)this.para(name), (Long)def);
    }

    public Boolean paraToBoolean(String name, Boolean def) {
        return ConvertKit.bool((String)this.para(name), (Boolean)def);
    }

    public Double paraToDouble(String name, Double def) {
        return ConvertKit.doubler((String)this.para(name), (Double)def);
    }

    public Date paraToDate(String name, String format, Date def) {
        return ConvertKit.date((String)this.para(name), (String)format, (Date)def);
    }

    public Map<String, String[]> paraMap() {
        if (this.paraMap != null) {
            return this.paraMap;
        }
        Map ret = new HashMap();
        QueryStringDecoder queryDecoder = new QueryStringDecoder(this.url(), this.config.charset());
        Map paras = queryDecoder.parameters();
        paras.forEach(ret::put);
        if (this.method() == Method.GET) {
            return super.mapListToArray(ret);
        }
        String contentType = this.header("content-type");
        if (TextKit.blanky((String)contentType)) {
            return super.mapListToArray(ret);
        }
        if ((contentType = contentType.toLowerCase()).startsWith("application/x-www-form-urlencoded")) {
            String body = null;
            RequestBody rb = this.body();
            if (rb != null) {
                body = rb.string();
            }
            if (TextKit.blankn(body)) {
                Map bodyParas;
                try {
                    bodyParas = EnoaHttpKit.parsePara((String)URLDecoder.decode(body, this.config.charset().name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                ret = super.mergeMap(ret, bodyParas);
            }
        }
        this.paraMap = super.paraMap(ret, this.binparas);
        return this.paraMap;
    }

    public String[] paraNames() {
        Map<String, String[]> paraMap = this.paraMap();
        if (CollectionKit.isEmpty(paraMap).booleanValue()) {
            return (String[])CollectionKit.emptyArray(String.class);
        }
        Set<String> paras = paraMap.keySet();
        return paras.toArray(new String[paras.size()]);
    }

    public String[] paraValues(String name) {
        Map<String, String[]> paraMap = this.paraMap();
        if (CollectionKit.isEmpty(paraMap).booleanValue()) {
            return (String[])CollectionKit.emptyArray(String.class);
        }
        return paraMap.get(name);
    }

    public Integer[] paraValuesToInt(String name) {
        String[] vals = this.paraValues(name);
        Integer[] rets = new Integer[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            rets[i] = ConvertKit.integer((String)vals[i]);
        }
        return rets;
    }

    public Long[] paraValuesToLong(String name) {
        String[] vals = this.paraValues(name);
        Long[] rets = new Long[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            rets[i] = ConvertKit.longer((String)vals[i]);
        }
        return rets;
    }

    public <T> T attr(String name) {
        return (T)this.request.attr(name);
    }

    public <T> Request attr(String name, T data) {
        this.request.attr(name, data);
        return this;
    }

    public String[] attrNames() {
        return this.request.attrNames();
    }

    public Request rmAttr(String name) {
        this.request.rmAttr(name);
        return this;
    }

    public UFile[] files() {
        return this.ufiles.toArray(new UFile[this.ufiles.size()]);
    }

    public UFile[] files(String name) {
        return (UFile[])this.ufiles.stream().filter(f -> f.name().equals(name)).toArray(UFile[]::new);
    }

    public UFile file(String name) {
        Object[] files = this.files(name);
        if (CollectionKit.isEmpty((Object[])files).booleanValue()) {
            return null;
        }
        return files[0];
    }

    public void clear() {
        this.request.clear();
        CollectionKit.clear((Collection[])new Collection[]{this.ufiles});
        CollectionKit.clear((Object[][])new Object[][]{this.cookies});
    }
}

