/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.provider.netty.ts;

import io.enoa.log.Log;
import io.enoa.repeater.EoxConfig;
import io.enoa.repeater.factory.name.EoxNameRuleFactory;
import io.enoa.repeater.http.Cookie;
import io.enoa.repeater.http.UFile;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.text.TextKit;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class NettyParser {
    private static ServerCookieDecoder cookieDecoder = ServerCookieDecoder.LAX;

    NettyParser() {
    }

    static Cookie[] parseCookies(String cookie) {
        if (TextKit.blanky((String)cookie)) {
            return (Cookie[])CollectionKit.emptyArray(Cookie.class);
        }
        Set cookies = cookieDecoder.decode(cookie);
        if (cookies == null) {
            return (Cookie[])CollectionKit.emptyArray(Cookie.class);
        }
        return (Cookie[])cookies.stream().map(c -> {
            Cookie.Builder builder = new Cookie.Builder().name(c.name()).value(c.value()).path(c.path()).expires(c.maxAge());
            if (c.domain() != null) {
                builder.domain(c.domain());
            }
            return builder.build();
        }).toArray(Cookie[]::new);
    }

    static ParseRet parsePostData(List<InterfaceHttpData> datas, EoxConfig config, EoxNameRuleFactory rule) {
        HashMap<String, List<String>> binparas = new HashMap<String, List<String>>();
        ArrayList<UFile> ufiles = new ArrayList<UFile>();
        for (InterfaceHttpData data : datas) {
            try {
                switch (data.getHttpDataType()) {
                    case Attribute: {
                        Attribute attribute = (Attribute)data;
                        String name = attribute.getName();
                        final String value = attribute.getValue();
                        List vals = (List)binparas.get(name);
                        if (CollectionKit.notEmpty((Collection)vals).booleanValue()) {
                            vals.add(value);
                            break;
                        }
                        binparas.put(name, (List<String>)new ArrayList<String>(){
                            {
                                this.add(value);
                            }
                        });
                        break;
                    }
                    case FileUpload: {
                        FileUpload fileUpload = (FileUpload)data;
                        String name = fileUpload.getName();
                        String originName = fileUpload.getFilename();
                        if (!fileUpload.isCompleted()) break;
                        UFile.Builder ufile = new UFile.Builder().name(name).tmp(config.tmp()).originName(originName);
                        if (config.holdFile()) {
                            ufiles.add(ufile.filename(originName).binary(fileUpload.getByteBuf().array()).build());
                            break;
                        }
                        String newname = rule.name(config.tmp(), originName);
                        Path newfilepath = config.tmp().resolve(newname);
                        fileUpload.renameTo(newfilepath.toFile());
                        ufiles.add(ufile.filename(newname).path(newfilepath).build());
                        break;
                    }
                    case InternalAttribute: {
                        break;
                    }
                }
            }
            catch (IOException e) {
                Log.error((String)e.getMessage(), (Throwable)e);
            }
        }
        return new ParseRet.Builder().paras(binparas).ufiles(ufiles).build();
    }

    static class ParseRet {
        private final Map<String, List<String>> paras;
        private final List<UFile> ufiles;

        private ParseRet(Builder builder) {
            this.paras = builder.paras;
            this.ufiles = builder.ufiles;
        }

        public Map<String, List<String>> paras() {
            return this.paras;
        }

        public List<UFile> ufiles() {
            return this.ufiles;
        }

        public void clear() {
            this.paras.clear();
            this.ufiles.clear();
        }

        private static class Builder {
            private Map<String, List<String>> paras;
            private List<UFile> ufiles;

            private Builder() {
            }

            public ParseRet build() {
                return new ParseRet(this);
            }

            public Builder paras(Map<String, List<String>> paras) {
                this.paras = paras;
                return this;
            }

            public Builder ufiles(List<UFile> ufiles) {
                this.ufiles = ufiles;
                return this;
            }
        }
    }
}

