/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.provider.netty.server;

import io.enoa.repeater.EoxAccessor;
import io.enoa.repeater.EoxConfig;
import io.enoa.repeater.factory.error.EoxErrorRenderFactory;
import io.enoa.repeater.factory.name.EoxNameRuleFactory;
import io.enoa.repeater.factory.ts.RepeaterTranslateFactory;
import io.enoa.repeater.provider.netty.server._NettyApp;
import io.enoa.repeater.provider.netty.server.plus._RepeaterNettyRequest;
import io.enoa.toolkit.alg.UnitConvKit;
import io.enoa.toolkit.number.NumberKit;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpServerCodec;

class _NettyAppInitializer
extends ChannelInitializer<SocketChannel> {
    private EoxAccessor accessor;
    private RepeaterTranslateFactory<_RepeaterNettyRequest, FullHttpResponse> ts;
    private EoxNameRuleFactory rule;
    private EoxConfig config;
    private EoxErrorRenderFactory errorRender;

    _NettyAppInitializer(EoxAccessor accessor, RepeaterTranslateFactory<_RepeaterNettyRequest, FullHttpResponse> ts, EoxNameRuleFactory rule, EoxErrorRenderFactory errorRender, EoxConfig config) {
        this.accessor = accessor;
        this.ts = ts;
        this.rule = rule;
        this.config = config;
        this.errorRender = errorRender;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline p = socketChannel.pipeline();
        p.addLast("codec", (ChannelHandler)new HttpServerCodec());
        p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.config.other().integer("max_content_length", NumberKit.integer((Number)UnitConvKit.convert((long)this.config.maxUploadSize(), (UnitConvKit.Unit)UnitConvKit.Unit.MB, (UnitConvKit.Unit)UnitConvKit.Unit.BYTE))).intValue()));
        p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        p.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        p.addLast("handler", (ChannelHandler)new _NettyApp(this.accessor, this.ts, this.rule, this.errorRender, this.config));
    }
}

