/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.provider.netty.server;

import io.enoa.repeater.EoxAccessor;
import io.enoa.repeater.EoxConfig;
import io.enoa.repeater.factory.error.EoxErrorRenderFactory;
import io.enoa.repeater.factory.name.EoxNameRuleFactory;
import io.enoa.repeater.factory.ts.RepeaterTranslateFactory;
import io.enoa.repeater.http.HttpStatus;
import io.enoa.repeater.http.Request;
import io.enoa.repeater.http.Response;
import io.enoa.repeater.http.ResponseBody;
import io.enoa.repeater.provider.netty.server.plus._RepeaterNettyRequest;
import io.enoa.repeater.provider.netty.server.plus._RepeaterNettyRequestImpl;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.http.UriKit;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;

class _NettyApp
extends ChannelInboundHandlerAdapter {
    private static final byte[] EMPTY = new byte[0];
    private EoxAccessor accessor;
    private RepeaterTranslateFactory<_RepeaterNettyRequest, FullHttpResponse> ts;
    private EoxNameRuleFactory rule;
    private EoxConfig config;
    private EoxErrorRenderFactory errorRender;

    _NettyApp(EoxAccessor accessor, RepeaterTranslateFactory<_RepeaterNettyRequest, FullHttpResponse> ts, EoxNameRuleFactory rule, EoxErrorRenderFactory errorRender, EoxConfig config) {
        this.accessor = accessor;
        this.ts = ts;
        this.config = config;
        this.rule = rule;
        this.errorRender = errorRender;
    }

    private void end(ChannelHandlerContext ctx, HttpRequest msg, FullHttpResponse response) {
        if (!HttpUtil.isKeepAlive((HttpMessage)msg)) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ctx.writeAndFlush((Object)response);
        }
        ReferenceCountUtil.release((Object)msg);
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof HttpRequest)) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        HttpRequest request = (HttpRequest)msg;
        if (!"/".equals(this.config.context())) {
            String context;
            String uri = request.uri();
            String[] uris = uri.split("\\?");
            uri = uris[0];
            if (!(uri = UriKit.correct((String)uri).concat("/")).startsWith(context = this.config.context().concat("/"))) {
                Response resp = this.errorRender.renderError(HttpStatus.NOT_FOUND, this.config.debug() ? EnoaTipKit.message((String)"eo.tip.repeater.context_no_match", (Object[])new Object[]{this.config.context()}) : null);
                ByteBuf body = ctx.alloc().buffer();
                body.writeBytes(resp.body().bytes());
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)resp.status().code()), body);
                this.ts.response(this.config, (Object)response, resp);
                this.end(ctx, request, (FullHttpResponse)response);
                return;
            }
        }
        try {
            FullHttpRequest fullRequest = (FullHttpRequest)msg;
            _RepeaterNettyRequestImpl nreq = new _RepeaterNettyRequestImpl(fullRequest){

                public String context() {
                    return _NettyApp.this.config.context();
                }
            };
            Request req = this.ts.request(this.config, this.rule, (Object)nreq);
            Response resp = this.accessor.access(req);
            ByteBuf body = ctx.alloc().buffer();
            ResponseBody rb = resp.body();
            body.writeBytes(rb == null ? EMPTY : rb.bytes());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)resp.status().code()), body);
            this.ts.response(this.config, (Object)response, resp);
            this.end(ctx, (HttpRequest)nreq, (FullHttpResponse)response);
        }
        catch (Exception e) {
            Response resp = this.errorRender.renderError(HttpStatus.NOT_FOUND, (Throwable)e);
            ByteBuf body = ctx.alloc().buffer();
            body.writeBytes(resp.body().bytes());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)resp.status().code()), body);
            this.ts.response(this.config, (Object)response, resp);
            this.end(ctx, request, (FullHttpResponse)response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

