/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.repeater.provider.netty.server;

import io.enoa.log.Log;
import io.enoa.repeater.EoxAccessor;
import io.enoa.repeater.EoxConfig;
import io.enoa.repeater.factory.provider.EoxProviderFactory;
import io.enoa.repeater.factory.server.RepeaterServer;
import io.enoa.repeater.factory.ts.RepeaterTranslateFactory;
import io.enoa.repeater.provider.netty.server._NettyAppInitializer;
import io.enoa.repeater.provider.netty.server.plus._RepeaterNettyRequest;
import io.enoa.toolkit.sys.EnvKit;
import io.enoa.toolkit.thr.EoException;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.FullHttpResponse;

class _Netty
implements RepeaterServer {
    private EoxAccessor accessor;

    _Netty(EoxAccessor accessor) {
        this.accessor = accessor;
    }

    public void listen(String hostname, int port, boolean ssly, EoxConfig config, EoxProviderFactory factor) {
        EnvKit.set((String)"io.netty.tmpdir", (String)config.tmp().toString());
        _NettyAppInitializer app = new _NettyAppInitializer(this.accessor, (RepeaterTranslateFactory<_RepeaterNettyRequest, FullHttpResponse>)factor.ts(), factor.rule(), factor.errorRender(), config);
        this.bind(app, port);
    }

    private void bind(final _NettyAppInitializer app, int port) {
        NioEventLoopGroup boss = new NioEventLoopGroup();
        NioEventLoopGroup worker = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)boss, (EventLoopGroup)worker);
            bootstrap.channel(NioServerSocketChannel.class);
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    ChannelPipeline p = socketChannel.pipeline();
                    p.addLast(new ChannelHandler[]{app});
                }
            });
            ChannelFuture f = bootstrap.bind(port).sync();
            if (f.isSuccess()) {
                Log.debug((String)"Boot netty server success.");
            }
            f.channel().closeFuture().sync();
        }
        catch (Exception e) {
            Log.error((String)"Boot neety server fail: ", (Object)e.getMessage(), (Object)e);
            throw new EoException(e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            boss.shutdownGracefully();
            worker.shutdownGracefully();
        }
    }
}

