/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis;

import io.enoa.nosql.redis.EPMRedis;
import io.enoa.nosql.redis.EnoaRedis;
import io.enoa.nosql.redis.EoRedisRunner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.Slowlog;

public class Redis {
    private Redis() {
    }

    public static EPMRedis epm() {
        return EPMRedis.instance();
    }

    public static EnoaRedis use(String name) {
        EnoaRedis redis = Redis.epm().redis(name);
        if (redis == null) {
            throw new NullPointerException("This redis client name is not exists. => " + name);
        }
        return redis;
    }

    public static EnoaRedis use() {
        return Redis.use("main");
    }

    public static Jedis jedis() {
        return Redis.use().jedis();
    }

    public static <T> T run(EoRedisRunner caller) {
        return Redis.use().run(caller);
    }

    public static String auth(String password) {
        return Redis.use().auth(password);
    }

    public static String echo(Object object) {
        return Redis.use().echo(object);
    }

    public static String ping() {
        return Redis.use().ping();
    }

    public static String quit() {
        return Redis.use().quit();
    }

    public static String select(int index) {
        return Redis.use().select(index);
    }

    public static Long geoadd(String key, double longitude, double latitude, String member) {
        return Redis.use().geoadd(key, longitude, latitude, member);
    }

    public static Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        return Redis.use().geoadd(key, memberCoordinateMap);
    }

    public static List<GeoCoordinate> geopos(String key, String ... members) {
        return Redis.use().geopos(key, members);
    }

    public static Double geodist(String key, String member1, String member2) {
        return Redis.use().geodist(key, member1, member2);
    }

    public static Double geodist(String key, String member1, String member2, GeoUnit unit) {
        return Redis.use().geodist(key, member1, member2, unit);
    }

    public static List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return Redis.use().georadius(key, longitude, latitude, radius, unit);
    }

    public static List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return Redis.use().georadius(key, longitude, latitude, radius, unit, param);
    }

    public static List<GeoRadiusResponse> georadiusbymember(String key, String member, double radius, GeoUnit unit) {
        return Redis.use().georadiusbymember(key, member, radius, unit);
    }

    public static List<GeoRadiusResponse> georadiusbymember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return Redis.use().georadiusbymember(key, member, radius, unit, param);
    }

    public static List<String> geohash(String key, String ... members) {
        return Redis.use().geohash(key, members);
    }

    public static Long hdel(String key, String ... field) {
        return Redis.use().hdel(key, field);
    }

    public static Boolean hexists(String key, String field) {
        return Redis.use().hexists(key, field);
    }

    public static <T> T hget(String key, String field) {
        return Redis.use().hget(key, field);
    }

    public static <T> Map<String, T> hgetall(String key) {
        return Redis.use().hgetall(key);
    }

    public static Long hincrby(String key, String field, long value) {
        return Redis.use().hincrby(key, field, value);
    }

    public static Double hincrbyfloat(String key, String field, double value) {
        return Redis.use().hincrbyfloat(key, field, value);
    }

    public static Set<String> hkeys(String key) {
        return Redis.use().hkeys(key);
    }

    public static Long hlen(String key) {
        return Redis.use().hlen(key);
    }

    public static <T> List<T> hmget(String key, String ... fields) {
        return Redis.use().hmget(key, fields);
    }

    public static String hmset(String key, Map<String, Object> hash) {
        return Redis.use().hmset(key, hash);
    }

    public static Long hset(String key, String field, Object value) {
        return Redis.use().hset(key, field, value);
    }

    public static Long hsetnx(String key, String field, Object value) {
        return Redis.use().hsetnx(key, field, value);
    }

    public static <T> List<T> hvals(String key) {
        return Redis.use().hvals(key);
    }

    public static <T> ScanResult<Map.Entry<String, T>> hscan(String key, String cursor) {
        return Redis.use().hscan(key, cursor);
    }

    public static <T> ScanResult<Map.Entry<String, T>> hscan(String key, String cursor, ScanParams params) {
        return Redis.use().hscan(key, cursor, params);
    }

    public static Long pfadd(String key, Object ... elements) {
        return Redis.use().pfadd(key, elements);
    }

    public static long pfcount(String ... key) {
        return Redis.use().pfcount(key);
    }

    public static long pfcount(String key) {
        return Redis.use().pfcount(key);
    }

    public static String pfmerge(String destkey, String ... sourcekeys) {
        return Redis.use().pfmerge(destkey, sourcekeys);
    }

    public static Long del(String key) {
        return Redis.use().del(key);
    }

    public static Long del(String ... keys) {
        return Redis.use().del(keys);
    }

    public static byte[] dump(String key) {
        return Redis.use().dump(key);
    }

    public static Boolean exists(String key) {
        return Redis.use().exists(key);
    }

    public static Long exists(String ... keys) {
        return Redis.use().exists(keys);
    }

    public static Long expire(String key, int seconds) {
        return Redis.use().expire(key, seconds);
    }

    public static Long expireat(String key, long unixTime) {
        return Redis.use().expireat(key, unixTime);
    }

    public static Set<String> keys(String pattern) {
        return Redis.use().keys(pattern);
    }

    public static String migrate(String host, int port, String key, int destinationDb, int timeout) {
        return Redis.use().migrate(host, port, key, destinationDb, timeout);
    }

    public static Long move(String key, int dbIndex) {
        return Redis.use().move(key, dbIndex);
    }

    public static String objectencoding(String string) {
        return Redis.use().objectencoding(string);
    }

    public static Long objectidletime(String string) {
        return Redis.use().objectidletime(string);
    }

    public static Long objectrefcount(String string) {
        return Redis.use().objectrefcount(string);
    }

    public static Long persist(String key) {
        return Redis.use().persist(key);
    }

    public static Long pexpire(String key, long milliseconds) {
        return Redis.use().pexpire(key, milliseconds);
    }

    public static Long pexpireat(String key, long millisecondsTimestamp) {
        return Redis.use().pexpireat(key, millisecondsTimestamp);
    }

    public static Long pttl(String key) {
        return Redis.use().pttl(key);
    }

    public static String randomkey() {
        return Redis.use().randomkey();
    }

    public static String rename(String oldkey, String newkey) {
        return Redis.use().rename(oldkey, newkey);
    }

    public static Long renamenx(String oldkey, String newkey) {
        return Redis.use().renamenx(oldkey, newkey);
    }

    public static String restore(String key, int ttl, byte[] serializedValue) {
        return Redis.use().restore(key, ttl, serializedValue);
    }

    public static <T> List<T> sort(String key) {
        return Redis.use().sort(key);
    }

    public static <T> List<T> sort(String key, SortingParams sortingParameters) {
        return Redis.use().sort(key, sortingParameters);
    }

    public static Long sort(String key, SortingParams sortingParameters, String dstkey) {
        return Redis.use().sort(key, sortingParameters, dstkey);
    }

    public static Long sort(String key, String dstkey) {
        return Redis.use().sort(key, dstkey);
    }

    public static Long ttl(String key) {
        return Redis.use().ttl(key);
    }

    public static String type(String key) {
        return Redis.use().type(key);
    }

    public static <T> ScanResult<T> scan(String cursor) {
        return Redis.use().scan(cursor);
    }

    public static <T> ScanResult<T> scan(String cursor, ScanParams params) {
        return Redis.use().scan(cursor, params);
    }

    public static <T> List<T> blpop(int timeout, String ... keys) {
        return Redis.use().blpop(timeout, keys);
    }

    public static <T> List<T> blpop(int timeout, String key) {
        return Redis.use().blpop(timeout, key);
    }

    public static <T> List<T> blpop(String ... args) {
        return Redis.use().blpop(args);
    }

    public static <T> List<T> brpop(int timeout, String ... keys) {
        return Redis.use().brpop(timeout, keys);
    }

    public static <T> List<T> brpop(int timeout, String key) {
        return Redis.use().brpop(timeout, key);
    }

    public static <T> List<T> brpop(String ... args) {
        return Redis.use().brpop(args);
    }

    public static <T> T brpoplpush(String source, String destination, int timeout) {
        return Redis.use().brpoplpush(source, destination, timeout);
    }

    public static String lindex(String key, long index) {
        return Redis.use().lindex(key, index);
    }

    public static Long linsert(String key, BinaryClient.LIST_POSITION where, Object pivot, Object value) {
        return Redis.use().linsert(key, where, pivot, value);
    }

    public static Long llen(String key) {
        return Redis.use().llen(key);
    }

    public static <T> T lpop(String key) {
        return Redis.use().lpop(key);
    }

    public static Long lpush(String key, Object ... values) {
        return Redis.use().lpush(key, values);
    }

    public static Long lpushx(String key, Object ... values) {
        return Redis.use().lpushx(key, values);
    }

    public static <T> List<T> lrange(String key, long start, long end) {
        return Redis.use().lrange(key, start, end);
    }

    public static Long lrem(String key, long count, Object value) {
        return Redis.use().lrem(key, count, value);
    }

    public static String lset(String key, long index, Object value) {
        return Redis.use().lset(key, index, value);
    }

    public static String ltrim(String key, long start, long end) {
        return Redis.use().ltrim(key, start, end);
    }

    public static <T> T rpop(String key) {
        return Redis.use().rpop(key);
    }

    public static <T> T rpoplpush(String srckey, String dstkey) {
        return Redis.use().rpoplpush(srckey, dstkey);
    }

    public static Long rpush(String key, Object ... values) {
        return Redis.use().rpush(key, values);
    }

    public static Long rpushx(String key, Object ... values) {
        return Redis.use().rpushx(key, values);
    }

    public static List<String> pubsubchannels(String pattern) {
        return Redis.use().pubsubchannels(pattern);
    }

    public static Long pubsubnumpat() {
        return Redis.use().pubsubnumpat();
    }

    public static Map<String, String> pubsubnumsub(String ... channels) {
        return Redis.use().pubsubnumsub(channels);
    }

    public static Long publish(String channel, Object message) {
        return Redis.use().publish(channel, message);
    }

    public static void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        Redis.use().psubscribe(jedisPubSub, patterns);
    }

    public static void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        Redis.use().subscribe(jedisPubSub, channels);
    }

    public static Object eval(String script, int keyCount, String ... params) {
        return Redis.use().eval(script, keyCount, params);
    }

    public static Object eval(String script, List<String> keys, List<String> args) {
        return Redis.use().eval(script, keys, args);
    }

    public static Object eval(String script) {
        return Redis.use().eval(script);
    }

    public static Object evalsha(String script) {
        return Redis.use().evalsha(script);
    }

    public static Object evalsha(String sha1, List<String> keys, List<String> args) {
        return Redis.use().evalsha(sha1, keys, args);
    }

    public static Object evalsha(String sha1, int keyCount, String ... params) {
        return Redis.use().evalsha(sha1, keyCount, params);
    }

    public static Boolean scriptexists(String sha1) {
        return Redis.use().scriptexists(sha1);
    }

    public static List<Boolean> scriptexists(String ... sha1) {
        return Redis.use().scriptexists(sha1);
    }

    public static String scriptflush() {
        return Redis.use().scriptflush();
    }

    public static String scriptkill() {
        return Redis.use().scriptkill();
    }

    public static String scriptload(String script) {
        return Redis.use().scriptload(script);
    }

    public static String bgrewriteaof() {
        return Redis.use().bgrewriteaof();
    }

    public static String bgsave() {
        return Redis.use().bgsave();
    }

    public static String clientgetname() {
        return Redis.use().clientgetname();
    }

    public static String clientkill(String client) {
        return Redis.use().clientkill(client);
    }

    public static String clientlist() {
        return Redis.use().clientlist();
    }

    public static String clientsetname(String name) {
        return Redis.use().clientsetname(name);
    }

    public static List<String> configget(String pattern) {
        return Redis.use().configget(pattern);
    }

    public static String configresetstat() {
        return Redis.use().configresetstat();
    }

    public static String configset(String parameter, String value) {
        return Redis.use().configset(parameter, value);
    }

    public static Long dbsize() {
        return Redis.use().dbsize();
    }

    public static String debug(DebugParams params) {
        return Redis.use().debug(params);
    }

    public static String flushall() {
        return Redis.use().flushall();
    }

    public static String flushdb() {
        return Redis.use().flushdb();
    }

    public static String info() {
        return Redis.use().info();
    }

    public static Long lastsave() {
        return Redis.use().lastsave();
    }

    public static void monitor(JedisMonitor jedisMonitor) {
        Redis.use().monitor(jedisMonitor);
    }

    public static String save() {
        return Redis.use().save();
    }

    public static String shutdown() {
        return Redis.use().shutdown();
    }

    public static String slaveof(String host, int port) {
        return Redis.use().slaveof(host, port);
    }

    public static List<Slowlog> slowlogget() {
        return Redis.use().slowlogget();
    }

    public static Long slowloglen() {
        return Redis.use().slowloglen();
    }

    public static String slowlogreset() {
        return Redis.use().slowlogreset();
    }

    public static void sync() {
        Redis.use().sync();
    }

    public static List<String> time() {
        return Redis.use().time();
    }

    public static Long sadd(String key, Object ... member) {
        return Redis.use().sadd(key, member);
    }

    public static Long scard(String key) {
        return Redis.use().scard(key);
    }

    public static <T> Set<T> sdiff(String ... keys) {
        return Redis.use().sdiff(keys);
    }

    public static Long sdiffstore(String dstkey, String ... keys) {
        return Redis.use().sdiffstore(dstkey, keys);
    }

    public static Boolean sismember(String key, Object member) {
        return Redis.use().sismember(key, member);
    }

    public static <T> Set<T> smembers(String key) {
        return Redis.use().smembers(key);
    }

    public static Long smove(String srckey, String dstkey, Object member) {
        return Redis.use().smove(srckey, dstkey, member);
    }

    public static <T> T spop(String key) {
        return Redis.use().spop(key);
    }

    public static <T> Set<T> spop(String key, long count) {
        return Redis.use().spop(key, count);
    }

    public static <T> T srandmember(String key) {
        return Redis.use().srandmember(key);
    }

    public static <T> List<T> srandmember(String key, int count) {
        return Redis.use().srandmember(key, count);
    }

    public static Long srem(String key, Object ... member) {
        return Redis.use().srem(key, member);
    }

    public static <T> Set<T> sunion(String ... keys) {
        return Redis.use().sunion(keys);
    }

    public static Long sunionstore(String dstkey, String ... keys) {
        return Redis.use().sunionstore(dstkey, keys);
    }

    public static <T> ScanResult<T> sscan(String key, String cursor) {
        return Redis.use().sscan(key, cursor);
    }

    public static <T> ScanResult<T> sscan(String key, String cursor, ScanParams params) {
        return Redis.use().sscan(key, cursor, params);
    }

    public static Long zadd(String key, double score, Object member) {
        return Redis.use().zadd(key, score, member);
    }

    public static Long zadd(String key, double score, Object member, ZAddParams params) {
        return Redis.use().zadd(key, score, member, params);
    }

    public static Long zadd(String key, Map<String, Double> scoreMembers) {
        return Redis.use().zadd(key, scoreMembers);
    }

    public static Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        return Redis.use().zadd(key, scoreMembers, params);
    }

    public static Long zcard(String key) {
        return Redis.use().zcard(key);
    }

    public static Long zcount(String key, double min, double max) {
        return Redis.use().zcount(key, min, max);
    }

    public static Long zcount(String key, Object min, Object max) {
        return Redis.use().zcount(key, min, max);
    }

    public static Double zincrby(String key, double score, Object member) {
        return Redis.use().zincrby(key, score, member);
    }

    public static Double zincrby(String key, double score, Object member, ZIncrByParams params) {
        return Redis.use().zincrby(key, score, member, params);
    }

    public static <T> Set<T> zrange(String key, long start, long end) {
        return Redis.use().zrange(key, start, end);
    }

    public static <T> Set<T> zrangebyscore(String key, double min, double max) {
        return Redis.use().zrangebyscore(key, min, max);
    }

    public static <T> Set<T> zrangebyscore(String key, T min, T max) {
        return Redis.use().zrangebyscore(key, min, max);
    }

    public static <T> Set<T> zrangebyscore(String key, double min, double max, int offset, int count) {
        return Redis.use().zrangebyscore(key, min, max, offset, count);
    }

    public static <T> Set<T> zrangebyscore(String key, T min, T max, int offset, int count) {
        return Redis.use().zrangebyscore(key, min, max, offset, count);
    }

    public static Long zrank(String key, Object member) {
        return Redis.use().zrank(key, member);
    }

    public static Long zrem(String key, Object ... member) {
        return Redis.use().zrem(key, member);
    }

    public static Long zremrangebyrank(String key, long start, long end) {
        return Redis.use().zremrangebyrank(key, start, end);
    }

    public static Long zremrangebyscore(String key, double start, double end) {
        return Redis.use().zremrangebyscore(key, start, end);
    }

    public static Long zremrangebyscore(String key, Object start, Object end) {
        return Redis.use().zremrangebyscore(key, start, end);
    }

    public static <T> Set<T> zrevrange(String key, long start, long end) {
        return Redis.use().zrevrange(key, start, end);
    }

    public static <T> Set<T> zrevrangebylex(String key, T max, T min) {
        return Redis.use().zrevrangebylex(key, max, min);
    }

    public static <T> Set<T> zrevrangebylex(String key, T max, T min, int offset, int count) {
        return Redis.use().zrevrangebylex(key, max, min, offset, count);
    }

    public static <T> Set<T> zrevrangebyscore(String key, double max, double min) {
        return Redis.use().zrevrangebyscore(key, max, min);
    }

    public static <T> Set<T> zrevrangebyscore(String key, T max, T min) {
        return Redis.use().zrevrangebyscore(key, max, min);
    }

    public static <T> Set<T> zrevrangebyscore(String key, double max, double min, int offset, int count) {
        return Redis.use().zrevrangebyscore(key, max, min, offset, count);
    }

    public static <T> Set<T> zrevrangebyscore(String key, T max, T min, int offset, int count) {
        return Redis.use().zrevrangebyscore(key, max, min, offset, count);
    }

    public static Long zrevrank(String key, Object member) {
        return Redis.use().zrevrank(key, member);
    }

    public static Double zscore(String key, Object member) {
        return Redis.use().zscore(key, member);
    }

    public static Long zunionstore(String dstkey, String ... sets) {
        return Redis.use().zunionstore(dstkey, sets);
    }

    public static Long zunionstore(String dstkey, ZParams params, String ... sets) {
        return Redis.use().zunionstore(dstkey, params, sets);
    }

    public static Long zinterstore(String dstkey, String ... sets) {
        return Redis.use().zinterstore(dstkey, sets);
    }

    public static Long zinterstore(String dstkey, ZParams params, String ... sets) {
        return Redis.use().zinterstore(dstkey, params, sets);
    }

    public static ScanResult<Tuple> zscan(String key, String cursor) {
        return Redis.use().zscan(key, cursor);
    }

    public static ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        return Redis.use().zscan(key, cursor, params);
    }

    public static <T> Set<T> zrangebylex(String key, T min, T max) {
        return Redis.use().zrangebylex(key, min, max);
    }

    public static <T> Set<T> zrangebylex(String key, T min, T max, int offset, int count) {
        return Redis.use().zrangebylex(key, min, max, offset, count);
    }

    public static Long zlexcount(String key, Object min, Object max) {
        return Redis.use().zlexcount(key, min, max);
    }

    public static Long zremrangebylex(String key, Object min, Object max) {
        return Redis.use().zremrangebylex(key, min, max);
    }

    public static Long append(String key, String value) {
        return Redis.use().append(key, value);
    }

    public static Long bitcount(String key) {
        return Redis.use().bitcount(key);
    }

    public static Long bitcount(String key, long start, long end) {
        return Redis.use().bitcount(key, start, end);
    }

    public static Long bitop(BitOP op, String destKey, String ... srcKeys) {
        return Redis.use().bitop(op, destKey, srcKeys);
    }

    public static List<Long> bitfield(String key, String ... arguments) {
        return Redis.use().bitfield(key, arguments);
    }

    public static Long decr(String key) {
        return Redis.use().decr(key);
    }

    public static Long decrby(String key, long integer) {
        return Redis.use().decrby(key, integer);
    }

    public static String get(String key) {
        return Redis.use().get(key);
    }

    public static Boolean getbit(String key, long offset) {
        return Redis.use().getbit(key, offset);
    }

    public static String getrange(String key, long startOffset, long endOffset) {
        return Redis.use().getrange(key, startOffset, endOffset);
    }

    public static String getset(String key, String value) {
        return Redis.use().getset(key, value);
    }

    public static Long incr(String key) {
        return Redis.use().incr(key);
    }

    public static Long incrby(String key, long integer) {
        return Redis.use().incrby(key, integer);
    }

    public static Double incrbyfloat(String key, double value) {
        return Redis.use().incrbyfloat(key, value);
    }

    public static List<String> mget(String ... keys) {
        return Redis.use().mget(keys);
    }

    public static String mset(String ... keysvalues) {
        return Redis.use().mset(keysvalues);
    }

    public static Long msetnx(String ... keysvalues) {
        return Redis.use().msetnx(keysvalues);
    }

    public static String psetex(String key, long milliseconds, String value) {
        return Redis.use().psetex(key, milliseconds, value);
    }

    public static String set(String key, String value) {
        return Redis.use().set(key, value);
    }

    public static String set(String key, String value, String nxxx) {
        return Redis.use().set(key, value, nxxx);
    }

    public static String set(String key, String value, String nxxx, String expx, int time) {
        return Redis.use().set(key, value, nxxx, expx, time);
    }

    public static Boolean setbit(String key, long offset, String value) {
        return Redis.use().setbit(key, offset, value);
    }

    public static String setex(String key, int seconds, String value) {
        return Redis.use().setex(key, seconds, value);
    }

    public static Long setnx(String key, String value) {
        return Redis.use().setnx(key, value);
    }

    public static Long setrange(String key, long offset, String value) {
        return Redis.use().setrange(key, offset, value);
    }

    public static Long strlen(String key) {
        return Redis.use().strlen(key);
    }

    public static Transaction multi() {
        return Redis.use().multi();
    }

    public static String unwatch() {
        return Redis.use().unwatch();
    }

    public static String watch(String ... keys) {
        return Redis.use().watch(keys);
    }
}

