/*
 * Copyright (c) 2018, enoa (fewensa@enoa.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.enoa.nosql.redis.command;

import redis.clients.jedis.Transaction;

interface TransactionCommand extends _Runner {

  default Transaction multi() {
    return this.run((jedis, serializer) -> jedis.multi());
  }

  default String unwatch() {
    return this.run((jedis, serializer) -> jedis.unwatch());
  }

  default String watch(String... keys) {
    return this.run((jedis, serializer) -> jedis.watch(keys));
  }

}
