/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis;

import io.enoa.nosql.redis.EoRedisRunner;
import io.enoa.nosql.redis.command._RedisCommand;
import io.enoa.serialization.EoSerializationFactory;
import io.enoa.serialization.EoSerializer;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class EnoaRedis
implements _RedisCommand {
    private Pool<Jedis> pool;
    private EoSerializer serializer;

    public EnoaRedis(Pool<Jedis> pool, EoSerializationFactory serialization) {
        this.pool = pool;
        this.serializer = serialization.serializer();
    }

    @Override
    public Jedis jedis() {
        return (Jedis)this.pool.getResource();
    }

    @Override
    public <T> T run(EoRedisRunner runner) {
        Jedis jedis = (Jedis)this.pool.getResource();
        Object ret = runner.run(jedis, this.serializer);
        this.close(jedis);
        return ret;
    }

    private void close(Jedis jedis) {
        if (jedis == null) {
            return;
        }
        jedis.close();
    }

    public void close() {
        this.pool.close();
    }
}

