/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis.command;

import io.enoa.nosql.redis.EnoaRedisConvert;
import io.enoa.nosql.redis.command._Runner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.util.SafeEncoder;

interface HashCommand
extends _Runner {
    default public Long hdel(String key, String ... field) {
        return (Long)this.run((jedis, serializer) -> jedis.hdel(key, field));
    }

    default public Boolean hexists(String key, String field) {
        return (Boolean)this.run((jedis, serializer) -> jedis.hexists(key, field));
    }

    default public <T> T hget(String key, String field) {
        return this.run((jedis, serializer) -> serializer.reduction(jedis.hget(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field))));
    }

    default public <T> Map<String, T> hgetall(String key) {
        return (Map)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertMap(jedis.hgetAll(SafeEncoder.encode((String)key))));
    }

    default public Long hincrby(String key, String field, long value) {
        return (Long)this.run((jedis, serializer) -> jedis.hincrBy(key, field, value));
    }

    default public Double hincrbyfloat(String key, String field, double value) {
        return (Double)this.run((jedis, serializer) -> jedis.hincrByFloat(key, field, value));
    }

    default public Set<String> hkeys(String key) {
        return (Set)this.run((jedis, serializer) -> jedis.hkeys(key));
    }

    default public Long hlen(String key) {
        return (Long)this.run((jedis, serializer) -> jedis.hlen(key));
    }

    default public <T> List<T> hmget(String key, String ... fields) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.hmget(SafeEncoder.encode((String)key), EnoaRedisConvert.with(serializer).toBytesKeys(fields))));
    }

    default public String hmset(String key, Map<String, Object> hash) {
        return (String)this.run((jedis, serializer) -> {
            Map<byte[], byte[]> trans = EnoaRedisConvert.with(serializer).serializeMap(hash);
            String ret = jedis.hmset(SafeEncoder.encode((String)key), trans);
            trans.clear();
            return ret;
        });
    }

    default public Long hset(String key, String field, Object value) {
        return (Long)this.run((jedis, serializer) -> jedis.hset(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), serializer.serialize(value)));
    }

    default public Long hsetnx(String key, String field, Object value) {
        return (Long)this.run((jedis, serializer) -> jedis.hsetnx(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), serializer.serialize(value)));
    }

    default public <T> List<T> hvals(String key) {
        return (List)this.run((jedis, serializer) -> EnoaRedisConvert.with(serializer).convertList(jedis.hvals(SafeEncoder.encode((String)key))));
    }

    default public <T> ScanResult<Map.Entry<String, T>> hscan(String key, String cursor) {
        return (ScanResult)this.run((jedis, serializer) -> {
            ScanResult data = jedis.hscan(SafeEncoder.encode((String)key), SafeEncoder.encode((String)cursor));
            List res = data.getResult().stream().map(EnoaRedisConvert.with(serializer)::convertEntry).collect(Collectors.toList());
            return new ScanResult(data.getCursorAsBytes(), res);
        });
    }

    default public <T> ScanResult<Map.Entry<String, T>> hscan(String key, String cursor, ScanParams params) {
        return (ScanResult)this.run((jedis, serializer) -> {
            ScanResult data = jedis.hscan(SafeEncoder.encode((String)key), SafeEncoder.encode((String)cursor), params);
            List res = data.getResult().stream().map(EnoaRedisConvert.with(serializer)::convertEntry).collect(Collectors.toList());
            return new ScanResult(data.getCursorAsBytes(), res);
        });
    }
}

