/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.nosql.redis;

import io.enoa.nosql.redis.EnoaRedis;
import io.enoa.nosql.redis.RedisConfig;
import io.enoa.nosql.redis.RedisSentinelConfig;
import io.enoa.serialization.EoSerializationFactory;
import io.enoa.serialization.provider.jdk.JdkSerializeProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class EPMRedis {
    private EoSerializationFactory defSerialization = new JdkSerializeProvider();
    private Map<String, EnoaRedis> pool = new HashMap<String, EnoaRedis>();

    private EPMRedis() {
    }

    static EPMRedis instance() {
        return Holder.INSTANCE;
    }

    public void install(String name, String host, int port, String passwd, EoSerializationFactory serialization) {
        RedisConfig config = new RedisConfig.Builder().name(name).host(host).port(port).passwd(passwd).build();
        this.install(config, serialization);
    }

    public void install(String name, String host, int port, EoSerializationFactory serialization) {
        this.install(name, host, port, null, serialization);
    }

    public void install(String host, int port, String passwd, EoSerializationFactory serialization) {
        RedisConfig config = new RedisConfig.Builder().host(host).port(port).passwd(passwd).build();
        this.install(config, serialization);
    }

    public void install(String host, int port, EoSerializationFactory serialization) {
        this.install(host, port, null, serialization);
    }

    public void install(RedisConfig config, EoSerializationFactory serialization) {
        if (this.pool.keySet().stream().anyMatch(config.name()::equals)) {
            throw new IllegalArgumentException("This name is already start. => " + config.name());
        }
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)(config.poolConfig() == null ? new GenericObjectPoolConfig() : config.poolConfig()), config.host(), config.port(), config.connectionTimeout().intValue(), config.soTimeout().intValue(), config.passwd(), config.database() == null ? 0 : config.database(), config.name(), config.ssl(), config.sslSocketFactory(), config.sslParameters(), config.hostnameVerifier());
        this.pool.put(config.name(), new EnoaRedis((Pool<Jedis>)pool, serialization == null ? this.defSerialization : serialization));
    }

    public void install(RedisSentinelConfig config, EoSerializationFactory serialization) {
        if (this.pool.keySet().stream().anyMatch(config.name()::equals)) {
            throw new IllegalArgumentException("This name is already start. => " + config.name());
        }
        JedisSentinelPool pool = new JedisSentinelPool(config.masterName(), config.sentinels(), (GenericObjectPoolConfig)(config.poolConfig() == null ? new GenericObjectPoolConfig() : config.poolConfig()), config.connectionTimeout(), config.soTimeout(), config.passwd(), config.database(), config.name());
        this.pool.put(config.name(), new EnoaRedis((Pool<Jedis>)pool, serialization == null ? this.defSerialization : serialization));
    }

    public void install(String name, String host, int port, String passwd) {
        this.install(name, host, port, passwd, this.defSerialization);
    }

    public void install(String name, String host, int port) {
        this.install(name, host, port, null, this.defSerialization);
    }

    public void install(String host, int port, String passwd) {
        this.install(host, port, passwd, this.defSerialization);
    }

    public void install(String host, int port) {
        this.install(host, port, null, this.defSerialization);
    }

    public void install(RedisConfig config) {
        this.install(config, this.defSerialization);
    }

    public void install(RedisSentinelConfig config) {
        this.install(config, this.defSerialization);
    }

    public void uninstall(String name) {
        EnoaRedis ers = this.pool.get(name);
        if (ers == null) {
            return;
        }
        ers.close();
        this.pool.remove(name);
    }

    public EnoaRedis redis(String name) {
        return this.pool.get(name);
    }

    private static class Holder {
        private static final EPMRedis INSTANCE = new EPMRedis();

        private Holder() {
        }
    }
}

