/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.index.solr.action.select;

import io.enoa.http.EoUrl;
import io.enoa.http.Http;
import io.enoa.http.protocol.HttpMethod;
import io.enoa.http.protocol.HttpPara;
import io.enoa.http.protocol.HttpResponse;
import io.enoa.index.solr.SolrConfig;
import io.enoa.index.solr.action._SolrAction;
import io.enoa.index.solr.action.select.Dismax;
import io.enoa.index.solr.action.select.Edismax;
import io.enoa.index.solr.action.select.Facet;
import io.enoa.index.solr.action.select.Hl;
import io.enoa.index.solr.action.select.Spatial;
import io.enoa.index.solr.action.select.Spellcheck;
import io.enoa.index.solr.cqp.Fq;
import io.enoa.index.solr.cqp.Sort;
import io.enoa.index.solr.cqp.Wt;
import io.enoa.index.solr.parser.SParser;
import io.enoa.toolkit.EoConst;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SSelect
implements _SolrAction {
    private SolrConfig config;
    private Http http;
    private String core;
    private String q;
    private Set<String> fqs;
    private Set<String> sorts;
    private long start;
    private long rows;
    private Set<String> fls;
    private String df;
    private String raw;
    private Wt wt;
    private boolean indent;
    private boolean debug;
    private Dismax dismax;
    private Edismax edismax;
    private Facet facet;
    private Hl hl;
    private Spatial spatial;
    private Spellcheck spellcheck;

    public SSelect(Http http, SolrConfig config, String core) {
        this.http = http;
        this.config = config;
        this.core = core;
        this.q = "*:*";
        this.start = 0L;
        this.rows = 10L;
        this.debug = Boolean.FALSE;
        this.indent = Boolean.TRUE;
    }

    public SSelect q(String q) {
        this.q = q;
        return this;
    }

    public SSelect fq(String fq) {
        if (fq == null) {
            return this;
        }
        if (this.fqs == null) {
            this.fqs = new HashSet<String>();
        }
        this.fqs.add(fq);
        return this;
    }

    public SSelect fq(String ... fqs) {
        for (String fq : fqs) {
            this.fq(fq);
        }
        return this;
    }

    public SSelect fq(Fq fq) {
        return this.fq(fq.string());
    }

    public SSelect fq(Fq ... fqs) {
        for (Fq fq : fqs) {
            this.fq(fq.string());
        }
        return this;
    }

    public SSelect fq(Collection<Fq> fqs) {
        fqs.forEach(fq -> this.fq(fq.string()));
        return this;
    }

    public SSelect sort(String sort) {
        if (sort == null) {
            return this;
        }
        if (this.sorts == null) {
            this.sorts = new HashSet<String>();
        }
        this.sorts.add(sort);
        return this;
    }

    public SSelect sort(String ... sorts) {
        for (String sort : sorts) {
            this.sort(sort);
        }
        return this;
    }

    public SSelect sort(Sort sort) {
        return this.sort(sort.string());
    }

    public SSelect sort(Sort ... sorts) {
        for (Sort sort : sorts) {
            this.sort(sort.string());
        }
        return this;
    }

    public SSelect sort(Collection<Sort> sorts) {
        sorts.forEach(sort -> this.sort(sort.string()));
        return this;
    }

    public SSelect start(long offset) {
        this.start = offset;
        return this;
    }

    public SSelect rows(long rows) {
        this.rows = rows;
        return this;
    }

    public SSelect limit(long offset, long rows) {
        this.start = offset;
        this.rows = rows;
        return this;
    }

    public SSelect fl(String fl) {
        if (fl == null) {
            return this;
        }
        if (this.fls == null) {
            this.fls = new HashSet<String>();
        }
        this.fls.add(fl);
        return this;
    }

    public SSelect fl(String ... fls) {
        for (String fl : fls) {
            this.fl(fl);
        }
        return this;
    }

    public SSelect fl(Collection<String> fls) {
        fls.forEach(this::fl);
        return this;
    }

    public SSelect df(String df) {
        this.df = df;
        return this;
    }

    public SSelect raw(String raw) {
        this.raw = raw;
        return this;
    }

    public SSelect wt(Wt wt) {
        this.wt = wt;
        return this;
    }

    public SSelect indent() {
        return this.indent(true);
    }

    public SSelect indent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public SSelect debug() {
        return this.debug(true);
    }

    public SSelect debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public Dismax dismax() {
        this.dismax = new Dismax(this);
        return this.dismax;
    }

    public Edismax edismax() {
        this.edismax = new Edismax(this);
        return this.edismax;
    }

    public Hl hl() {
        this.hl = new Hl(this);
        return this.hl;
    }

    public Facet facet() {
        this.facet = new Facet(this);
        return this.facet;
    }

    public Spatial spatial() {
        this.spatial = new Spatial(this);
        return this.spatial;
    }

    public Spellcheck spellcheck() {
        this.spellcheck = new Spellcheck(this);
        return this.spellcheck;
    }

    @Override
    public <T> T emit(SParser<T> parser) {
        this.http.method(HttpMethod.GET).url(EoUrl.with((String)this.config.host()).subpath(this.core).subpath("select")).charset(EoConst.CHARSET).encode();
        this.http.para("_", (Object)System.currentTimeMillis());
        this.http.para("q", (Object)this.q);
        if (this.fqs != null) {
            this.fqs.forEach(fq -> this.http.para("fq", fq));
        }
        if (this.sorts != null) {
            this.http.para("sort", (Object)String.join((CharSequence)",", this.sorts));
        }
        this.http.para("start", (Object)this.start);
        this.http.para("rows", (Object)this.rows);
        if (this.fls != null) {
            this.http.para("fl", (Object)String.join((CharSequence)",", this.fls));
        }
        if (this.df != null) {
            this.http.para("df", (Object)this.df);
        }
        if (this.wt != null) {
            this.http.para("wt", (Object)this.wt.val());
        }
        if (this.raw != null) {
            this.http.para((Collection)HttpPara.parse((String)this.raw));
        }
        if (!this.indent) {
            this.http.para("indent", (Object)"off");
        }
        if (this.debug) {
            this.http.para("debugQuery", (Object)"on");
        }
        if (this.dismax != null) {
            this.http.para(this.dismax.paras());
        }
        if (this.edismax != null) {
            this.http.para(this.edismax.paras());
        }
        if (this.hl != null) {
            this.http.para(this.hl.paras());
        }
        if (this.facet != null) {
            this.http.para(this.facet.paras());
        }
        if (this.spatial != null) {
            this.http.para(this.spatial.paras());
        }
        if (this.spellcheck != null) {
            this.http.para(this.spellcheck.paras());
        }
        HttpResponse response = this.http.emit();
        return parser.result(response);
    }
}

