/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.index.solr;

import io.enoa.http.EoHttp;
import io.enoa.http.Http;
import io.enoa.http.HttpAuth;

public class SolrConfig {
    private final String host;
    private final EoHttp http;
    private final HttpAuth auth;
    private final boolean debug;

    private SolrConfig(Builder builder) {
        this.host = builder.host;
        this.auth = builder.auth;
        this.http = builder.http;
        this.debug = builder.debug;
    }

    public String host() {
        return this.host;
    }

    public HttpAuth auth() {
        return this.auth;
    }

    public boolean debug() {
        return this.debug;
    }

    public Http http() {
        Http http = this.http.http();
        if (this.auth != null) {
            http.auth(this.auth);
        }
        return http;
    }

    public static class Builder {
        private String host;
        private EoHttp http;
        private HttpAuth auth;
        private boolean debug = Boolean.FALSE;

        public Builder() {
            this.http = EoHttp.def();
        }

        public SolrConfig build() {
            return new SolrConfig(this);
        }

        public Builder http(EoHttp http) {
            this.http = http;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder auth(HttpAuth auth) {
            this.auth = auth;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }
    }
}

