/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.index.solr.cqp;

import io.enoa.index.solr.cqp.OrderBy;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.text.TextKit;
import java.io.Serializable;

public class Sort
implements Serializable {
    private String field;
    private OrderBy order;

    public Sort(String field, OrderBy order) {
        if (TextKit.blanky((String)field)) {
            throw new IllegalArgumentException(EnoaTipKit.message((String)"eo.tip.solr.cqp_sort_field_null", (Object[])new Object[0]));
        }
        if (order == null) {
            throw new IllegalArgumentException(EnoaTipKit.message((String)"eo.tip.solr.cqp_sort_order_null", (Object[])new Object[0]));
        }
        this.field = field;
        this.order = order;
    }

    public static Sort create(String field, OrderBy order) {
        return new Sort(field, order);
    }

    public String field() {
        return this.field;
    }

    public OrderBy order() {
        return this.order;
    }

    public String string() {
        return TextKit.union((String)this.field, (Object[])new Object[]{" ", this.order.val()});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Sort sort = (Sort)object;
        if (this.field != null ? !this.field.equals(sort.field) : sort.field != null) {
            return false;
        }
        return this.order == sort.order;
    }

    public int hashCode() {
        int result = this.field != null ? this.field.hashCode() : 0;
        result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.string();
    }
}

