/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.index.solr;

public class SolrConfig {
    private final String host;
    private final String user;
    private final String passwd;
    private final boolean debug;

    public SolrConfig(Builder builder) {
        this.host = builder.host;
        this.user = builder.user;
        this.passwd = builder.passwd;
        this.debug = builder.debug;
    }

    public String host() {
        return this.host;
    }

    public String user() {
        return this.user;
    }

    public String passwd() {
        return this.passwd;
    }

    public boolean debug() {
        return this.debug;
    }

    public static class Builder {
        private String host;
        private String user;
        private String passwd;
        private boolean debug = Boolean.FALSE;

        public SolrConfig build() {
            return new SolrConfig(this);
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }
    }
}

