/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.typebuilder;

import io.enoa.typebuilder.impl.ParameterizedTypeImpl;
import io.enoa.typebuilder.impl.WildcardTypeImpl;
import io.enoa.typebuilder.thr.TypeException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class TypeBuilder {
    private final TypeBuilder parent;
    private final Class raw;
    private final List<Type> args = new ArrayList<Type>();

    private TypeBuilder(Class raw, TypeBuilder parent) {
        assert (raw != null);
        this.raw = raw;
        this.parent = parent;
    }

    public static TypeBuilder with(Class raw) {
        return new TypeBuilder(raw, null);
    }

    private static TypeBuilder with(Class raw, TypeBuilder parent) {
        return new TypeBuilder(raw, parent);
    }

    public TypeBuilder beginSubType(Class raw) {
        return TypeBuilder.with(raw, this);
    }

    public TypeBuilder endSubType() {
        if (this.parent == null) {
            throw new TypeException("expect beginSubType() before endSubType()");
        }
        this.parent.type(this.getType());
        return this.parent;
    }

    public TypeBuilder type(Class clazz) {
        return this.type((Type)clazz);
    }

    public TypeBuilder typeExtends(Class ... classes) {
        if (classes == null) {
            throw new NullPointerException("typeExtends() expect not null Class");
        }
        WildcardTypeImpl wildcardType = new WildcardTypeImpl(null, classes);
        return this.type(wildcardType);
    }

    public TypeBuilder typeSuper(Class ... classes) {
        if (classes == null) {
            throw new NullPointerException("typeSuper() expect not null Class");
        }
        WildcardTypeImpl wildcardType = new WildcardTypeImpl(classes, null);
        return this.type(wildcardType);
    }

    public TypeBuilder type(Type type) {
        if (type == null) {
            throw new NullPointerException("type expect not null Type");
        }
        this.args.add(type);
        return this;
    }

    public Type build() {
        if (this.parent != null) {
            throw new TypeException("expect endSubType() before build()");
        }
        return this.getType();
    }

    private Type getType() {
        if (this.args.isEmpty()) {
            return this.raw;
        }
        return new ParameterizedTypeImpl(this.raw, this.args.toArray(new Type[this.args.size()]), null);
    }
}

