/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.text;

import io.enoa.toolkit.text.TextKit;

public class TextReader {
    private String text;
    private int len;
    private int position;
    private int line;
    private int cursor;

    public TextReader(String text) {
        this.text = text;
        this.len = text.length();
        this.line = 1;
    }

    public static TextReader with(String text) {
        return new TextReader(text);
    }

    public TextReader reset() {
        this.line = 1;
        this.position = 0;
        this.cursor = 0;
        return this;
    }

    public char peek() {
        if (this.position - 1 >= this.len) {
            return '\uffff';
        }
        if (this.position == 0) {
            return '\uffff';
        }
        return this.text.charAt(this.position - 1);
    }

    public char next() {
        if (!this.hasNext()) {
            return '\uffff';
        }
        char ch = this.text.charAt(this.position);
        ++this.position;
        ++this.cursor;
        if (ch == '\n') {
            ++this.line;
            this.cursor = 0;
        }
        return ch;
    }

    public int position() {
        return this.position;
    }

    public int line() {
        return this.line;
    }

    public int cursor() {
        return this.cursor;
    }

    public String thisLine() {
        char ch;
        int _position = this.position;
        int _cursor = this.cursor;
        int _line = this.line;
        while (this.back().peek() != '\n' && this.position != 0 && this.cursor != 0) {
        }
        StringBuilder builder = new StringBuilder();
        while (this.hasNext() && (ch = this.next()) != '\n') {
            builder.append(ch);
        }
        this.position = _position;
        this.cursor = _cursor;
        this.line = _line;
        String lineText = builder.toString();
        builder.delete(0, builder.length());
        return lineText;
    }

    public TextReader back() {
        char ch;
        if (this.position == 0) {
            return this;
        }
        char peek = this.peek();
        if (peek == '\uffff') {
            return this;
        }
        if (peek != '\n') {
            --this.position;
            --this.cursor;
            return this;
        }
        --this.position;
        --this.line;
        int _position = this.position;
        int _line = this.line;
        int distance = 0;
        while ((ch = this.back().peek()) != '\n' && ch != '\uffff') {
            ++distance;
        }
        this.position = _position;
        this.line = _line;
        this.cursor = distance + 1;
        return this;
    }

    public boolean hasNext() {
        return this.position < this.len;
    }

    public String text() {
        return this.text;
    }

    public String toString() {
        return TextKit.union("LENGTH: ", this.len, Character.valueOf(','), " POSITION: ", this.position, Character.valueOf(','), " LINE: ", this.line, Character.valueOf(','), " CURSOR: ", this.cursor, Character.valueOf(','), " TEXT => ", this.text.replace("\n", "\\n").replace("\r", "\\r").replace("\b", "\\b"));
    }
}

