/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.text;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.text.TextKit;
import java.util.Arrays;

public class CiphertextKit {
    private static final String PLACEHOLDER = "*";
    private static final int DEF_LEN_BER = 5;

    private CiphertextKit() {
    }

    public static String left(String text) {
        return CiphertextKit.left(text, 5, PLACEHOLDER);
    }

    public static String left(String text, int len) {
        return CiphertextKit.left(text, len, PLACEHOLDER);
    }

    public static String left(String text, int len, String placeholder) {
        if (TextKit.nully(placeholder)) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.str_ciphertext_placeholder_null", new Object[0]));
        }
        return CiphertextKit.encrypt(Direction.LEFT, text, len, placeholder.charAt(0));
    }

    public static String right(String text) {
        return CiphertextKit.right(text, 5, PLACEHOLDER);
    }

    public static String right(String text, int len) {
        return CiphertextKit.right(text, len, PLACEHOLDER);
    }

    public static String right(String text, int len, String placeholder) {
        if (TextKit.nully(placeholder)) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.str_ciphertext_placeholder_null", new Object[0]));
        }
        return CiphertextKit.encrypt(Direction.RIGHT, text, len, placeholder.charAt(0));
    }

    public static String middle(String text) {
        return CiphertextKit.middle(text, 5, PLACEHOLDER);
    }

    public static String middle(String text, int len) {
        return CiphertextKit.middle(text, len, PLACEHOLDER);
    }

    public static String middle(String text, int len, String placeholder) {
        if (TextKit.nully(placeholder)) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.str_ciphertext_placeholder_null", new Object[0]));
        }
        return CiphertextKit.encrypt(Direction.MIDDLE, text, len, placeholder.charAt(0));
    }

    public static String full(String text) {
        return CiphertextKit.full(text, PLACEHOLDER);
    }

    public static String full(String text, String placeholder) {
        if (text == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        int i = text.length();
        while (i-- > 0) {
            ret.append(placeholder);
        }
        return ret.toString();
    }

    private static String encrypt(Direction direction, String text, int len, char placeholder) {
        if (text == null) {
            return null;
        }
        if ("".equals(text)) {
            return text;
        }
        char[] chars = text.toCharArray();
        switch (direction) {
            case LEFT: {
                for (int i = 0; i < chars.length && i + 1 <= len; ++i) {
                    chars[i] = placeholder;
                }
                return new String(chars);
            }
            case RIGHT: {
                int i = chars.length;
                for (int times = 1; i-- > 0 && times <= len; ++times) {
                    chars[i] = placeholder;
                }
                return new String(chars);
            }
            case MIDDLE: {
                int toix;
                if (len > chars.length) {
                    Arrays.fill(chars, placeholder);
                    return new String(chars);
                }
                int spix = chars.length / 3;
                int remineLen = chars.length - spix;
                if (remineLen < len) {
                    spix = len - remineLen;
                }
                if (spix < 0) {
                    spix = 0;
                }
                Arrays.fill(chars, spix, (toix = len + spix) > chars.length ? chars.length - 1 : toix, placeholder);
                return new String(chars);
            }
        }
        throw new IllegalArgumentException("Invalid ciphertext direction.");
    }

    private static enum Direction {
        LEFT,
        RIGHT,
        MIDDLE;

    }
}

