/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.sys;

import io.enoa.toolkit.text.TextKit;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectKit {
    public static String string(Object object) {
        return object == null ? null : object.toString();
    }

    public static String buildToString(Object object) {
        Class<?> clazz = object.getClass();
        String cname = clazz.getName();
        StringBuilder tos = new StringBuilder();
        Set mnames = Stream.of(clazz.getMethods()).filter(m -> !m.getName().startsWith("set")).filter(m -> m.getParameterTypes().length == 0).map(Method::getName).collect(Collectors.toSet());
        do {
            Field[] dfields = clazz.getDeclaredFields();
            try {
                for (Field field : dfields) {
                    if (field.isAccessible()) {
                        Object o = field.get(object);
                        System.out.println(1);
                        tos.append(field.getName()).append(": ");
                        ObjectKit.fillObjectString(tos, o);
                        tos.append(", ");
                        continue;
                    }
                    String fname = field.getName();
                    Method method = null;
                    if (mnames.stream().anyMatch(fname::equals)) {
                        method = clazz.getMethod(fname, new Class[0]);
                    } else {
                        String nfname = TextKit.union("get", TextKit.upperFirst(fname));
                        if (mnames.stream().anyMatch(nfname::equals)) {
                            method = clazz.getMethod(nfname, new Class[0]);
                        }
                    }
                    if (method == null) continue;
                    Object o = method.invoke(object, new Object[0]);
                    tos.append(fname).append(": ");
                    ObjectKit.fillObjectString(tos, o);
                    tos.append(", ");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        if (tos.length() > 0) {
            tos.delete(tos.length() - 2, tos.length());
        }
        tos.insert(0, cname.substring(cname.lastIndexOf(".") + 1) + " => { ");
        tos.append(" }");
        return tos.toString();
    }

    private static void fillObjectString(StringBuilder tos, Object object) {
        if (object == null) {
            tos.append("null");
            return;
        }
        if (!object.getClass().isArray()) {
            tos.append(object);
            return;
        }
        int _len = Array.getLength(object);
        boolean _overflow = _len > 30;
        int _max = _len > 30 ? 30 : _len;
        StringBuilder _ars = new StringBuilder(_max * 3 + 5);
        _ars.append('[');
        for (int i = 0; i < _max; ++i) {
            _ars.append(Array.get(object, i));
            if (i + 1 >= _max) continue;
            _ars.append(", ");
        }
        if (_overflow) {
            _ars.append(" ...");
        }
        _ars.append("]");
        tos.append((CharSequence)_ars);
    }
}

