/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.random;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import java.util.Random;

public class RandomKit {
    private static final Random RANDOM = new Random();

    public static boolean nextBoolean() {
        return RANDOM.nextBoolean();
    }

    private static void valid(boolean cond, String message) {
        if (cond) {
            return;
        }
        throw new IllegalArgumentException(message);
    }

    public static byte[] nextBytes(int count) {
        RandomKit.valid(count >= 0, EnoaTipKit.message("eo.tip.toolkit.count_no_negative", new Object[0]));
        byte[] result = new byte[count];
        RANDOM.nextBytes(result);
        return result;
    }

    public static int nextInt(int start, int end) {
        RandomKit.valid(end >= start, EnoaTipKit.message("eo.tip.toolkit.start_gt_end", new Object[0]));
        RandomKit.valid(start >= 0, EnoaTipKit.message("eo.tip.toolkit.both_range_no_negative", new Object[0]));
        if (start == end) {
            return start;
        }
        return start + RANDOM.nextInt(end - start);
    }

    public static int nextInt() {
        return RandomKit.nextInt(0, Integer.MAX_VALUE);
    }

    public static long nextLong(long start, long end) {
        RandomKit.valid(end >= start, EnoaTipKit.message("eo.tip.toolkit.start_gt_end", new Object[0]));
        RandomKit.valid(start >= 0L, EnoaTipKit.message("eo.tip.toolkit.both_range_no_negative", new Object[0]));
        if (start == end) {
            return start;
        }
        return (long)RandomKit.nextDouble(start, end);
    }

    public static long nextLong() {
        return RandomKit.nextLong(0L, Long.MAX_VALUE);
    }

    public static double nextDouble(double start, double endInclusive) {
        RandomKit.valid(endInclusive >= start, EnoaTipKit.message("eo.tip.toolkit.start_gt_end", new Object[0]));
        RandomKit.valid(start >= 0.0, EnoaTipKit.message("eo.tip.toolkit.both_range_no_negative", new Object[0]));
        if (start == endInclusive) {
            return start;
        }
        return start + (endInclusive - start) * RANDOM.nextDouble();
    }

    public static double nextDouble() {
        return RandomKit.nextDouble(0.0, Double.MAX_VALUE);
    }

    public static float nextFloat(float start, float endInclusive) {
        RandomKit.valid(endInclusive >= start, EnoaTipKit.message("eo.tip.toolkit.start_gt_end", new Object[0]));
        RandomKit.valid(start >= 0.0f, EnoaTipKit.message("eo.tip.toolkit.both_range_no_negative", new Object[0]));
        if (start == endInclusive) {
            return start;
        }
        return start + (endInclusive - start) * RANDOM.nextFloat();
    }

    public static float nextFloat() {
        return RandomKit.nextFloat(0.0f, Float.MAX_VALUE);
    }
}

