/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.prop;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.prop.Prop;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.thr.EoException;
import io.enoa.toolkit.value.EnoaValue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class PropKit {
    private static Map<String, EnoaValue> PROPS = new ConcurrentHashMap<String, EnoaValue>();

    private PropKit() {
    }

    private static void loadProps(String ... suffix) {
        Enumeration<URL> urls;
        PROPS.clear();
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources("");
        }
        catch (IOException e) {
            throw new EoException(e);
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File fds = new File(url.getPath());
            Object[] fs = fds.listFiles(f -> Stream.of(suffix).anyMatch(s -> f.getAbsolutePath().endsWith(s.startsWith(".") ? s : TextKit.union(".", s))));
            if (CollectionKit.isEmpty(fs).booleanValue()) continue;
            for (Object f2 : fs) {
                Prop prop = new Prop((File)f2);
                prop.keys().forEach(key -> PROPS.put((String)key, prop.value((String)key)));
            }
        }
    }

    public static void reload() {
        PropKit.loadProps("properties");
    }

    public static void reload(String suffix) {
        PropKit.loadProps(suffix);
    }

    public static void reload(String ... suffix) {
        PropKit.loadProps(suffix);
    }

    public static void add(String filename) {
        PropKit.add(new Prop(filename));
    }

    public static void add(Prop prop) {
        Set<String> keys = prop.keys();
        keys.forEach(key -> PROPS.put((String)key, prop.value((String)key)));
    }

    public static void clear() {
        PROPS.clear();
    }

    public static EnoaValue value(String key) {
        EnoaValue value = PROPS.get(key);
        return value == null ? EnoaValue.NULL : value;
    }

    public static String string(String key) {
        return PropKit.value(key).string();
    }

    public static String string(String key, String def) {
        return PropKit.value(key).string(def);
    }

    public static Integer integer(String key) {
        return PropKit.value(key).integer();
    }

    public static Integer integer(String key, Integer def) {
        return PropKit.value(key).integer(def);
    }

    public static Long longer(String key) {
        return PropKit.value(key).longer();
    }

    public static Long longer(String key, Long def) {
        return PropKit.value(key).longer(def);
    }

    public static Boolean bool(String key) {
        return PropKit.value(key).bool();
    }

    public static Boolean bool(String key, Boolean def) {
        return PropKit.value(key).bool(def);
    }

    public static Set<String> keys() {
        return PROPS.keySet();
    }

    public static boolean exists(String key) {
        return PROPS.containsKey(key);
    }

    static {
        PropKit.loadProps("properties");
    }
}

