/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.path;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.http.UriKit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathKit {
    private static Path BOOT_PATH;
    private static Path USER_HOME;
    private static List<Path> RESOURCES_PATH;
    private static Map<String, Path> SUBPATHCACHE;

    private static Path toPath(URL url, String ... subpaths) {
        if (url == null) {
            return null;
        }
        try {
            return Paths.get(Paths.get(url.toURI().getPath(), new String[0]).toString(), subpaths);
        }
        catch (Exception e) {
            return Paths.get(new File(url.getFile()).getAbsolutePath(), subpaths);
        }
    }

    private static ClassLoader classLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader == null ? PathKit.class.getClassLoader() : loader;
    }

    private static void initResourcesPath() throws IOException {
        Enumeration<URL> urls = PathKit.classLoader().getResources("");
        while (urls.hasMoreElements()) {
            URL u0 = urls.nextElement();
            RESOURCES_PATH.add(PathKit.toPath(u0, new String[0]));
        }
    }

    private static Path detectPath(String subpath) {
        if ((subpath = Paths.get(UriKit.correct(subpath), new String[0]).toString()).length() == 1) {
            subpath = "";
        }
        for (Path resource : RESOURCES_PATH) {
            if (resource.endsWith(subpath)) {
                return resource;
            }
            Path correct = PathKit.correct(resource, subpath);
            if (correct == null) continue;
            SUBPATHCACHE.put(subpath, correct);
            return correct;
        }
        throw new RuntimeException(new FileNotFoundException(EnoaTipKit.message("eo.tip.toolkit.path_resource_404", subpath)));
    }

    private static Path correct(Path path, String subpath) {
        Path p0 = Paths.get(path.toString(), subpath);
        if (Files.exists(p0, new LinkOption[0])) {
            return p0;
        }
        ArrayList<String> pathTree = new ArrayList<String>();
        try {
            PathKit.pathTree(pathTree, path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String tree : pathTree) {
            if (!tree.endsWith(subpath)) continue;
            return Paths.get(tree, new String[0]);
        }
        return null;
    }

    private static void pathTree(List<String> trees, Path path) throws IOException {
        Files.list(path).forEach(sub -> {
            if (Files.isRegularFile(sub, new LinkOption[0])) {
                return;
            }
            trees.add(sub.toString());
            try {
                PathKit.pathTree(trees, path.resolve((Path)sub));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public static Path debugPath() {
        try {
            Path ret = Paths.get(PathKit.class.getResource("/").toURI());
            if (ret.endsWith(Paths.get("target", "classes")) || ret.endsWith(Paths.get("target", "test-classes"))) {
                return ret.getParent().getParent();
            }
            return BOOT_PATH;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Path userHome() {
        return USER_HOME;
    }

    public static Path[] resources() {
        return RESOURCES_PATH.toArray(new Path[RESOURCES_PATH.size()]);
    }

    public static Path path() {
        return PathKit.path("");
    }

    public static Path path(String subpath) {
        if (subpath == null) {
            throw new IllegalArgumentException(EnoaTipKit.message("eo.tip.toolkit.path_subpath_null", new Object[0]));
        }
        Path pat = SUBPATHCACHE.get(subpath);
        if (pat != null) {
            return pat;
        }
        return PathKit.detectPath(subpath);
    }

    static {
        SUBPATHCACHE = new HashMap<String, Path>();
        USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
        BOOT_PATH = Paths.get(System.getProperty("user.dir"), new String[0]);
        RESOURCES_PATH = new ArrayList<Path>();
        try {
            PathKit.initResourcesPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

