/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.image;

import io.enoa.toolkit.digest.base.BaseKit;
import io.enoa.toolkit.file.FileKit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;

public class ImageKit {
    private ImageKit() {
    }

    public static String datauri(String path) throws IOException {
        return ImageKit.datauri(Paths.get(path, new String[0]));
    }

    public static String datauri(Path path) throws IOException {
        String type = FileKit.extension(path).toLowerCase();
        if ("jpg".equals(type)) {
            type = "jpeg";
        }
        return "data:image/" + type + ";base64," + ImageKit.base64(path);
    }

    public static String base64(String path) throws IOException {
        return ImageKit.base64(Paths.get(path, new String[0]));
    }

    public static String base64(Path path) throws IOException {
        BufferedImage bi = ImageIO.read(path.toFile());
        String type = FileKit.extension(path).toLowerCase();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, type, baos);
        return BaseKit.ebase64(baos.toByteArray());
    }
}

