/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.ethernet;

import io.enoa.toolkit.ethernet.EthInfo;
import io.enoa.toolkit.ethernet.Ethernet;
import io.enoa.toolkit.ethernet.IP;
import io.enoa.toolkit.ethernet.MAC;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

class _EthernetLocal {
    _EthernetLocal() {
    }

    static _EthernetLocal instance() {
        return Holder.INSTANCE;
    }

    Ethernet local() {
        try {
            Ethernet ethernet = new Ethernet();
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface nif = interfaces.nextElement();
                Enumeration<InetAddress> addresses = nif.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null) continue;
                    EthInfo.Builder builder = new EthInfo.Builder();
                    builder.nif(nif).name(nif.getName()).address(ip);
                    byte[] mac = NetworkInterface.getByInetAddress(ip).getHardwareAddress();
                    builder.mac(new MAC(mac));
                    if (ip instanceof Inet4Address) {
                        builder.ip(IP.create(IP.Version.FOUR, ip.getHostAddress()));
                    }
                    if (ip instanceof Inet6Address) {
                        builder.ip(IP.create(IP.Version.SIX, ip.getHostAddress()));
                    }
                    ethernet.add(builder.build());
                }
            }
            ethernet.unmodifiable();
            return ethernet;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static class Holder {
        private static final _EthernetLocal INSTANCE = new _EthernetLocal();

        private Holder() {
        }
    }
}

