/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.ethernet;

import io.enoa.toolkit.mark.IMarkIx;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.text.TextReader;

public class IP {
    private final String text;
    private final String eth;
    private final String mask;
    private final Version version;

    private IP(Builder builder) {
        this.text = builder.text;
        this.eth = builder.eth;
        this.mask = builder.mask;
        this.version = builder.version;
    }

    public static IP create(Version version, String text) {
        if (TextKit.blanky(text)) {
            return null;
        }
        TextReader reader = new TextReader(text);
        StringBuilder ipb = new StringBuilder(text.length());
        StringBuilder ethb = new StringBuilder();
        StringBuilder maskb = new StringBuilder();
        while (reader.hasNext()) {
            char now = reader.next();
            if (now == '%') {
                while (reader.hasNext()) {
                    ethb.append(reader.next());
                }
            }
            if (now == '/') {
                while (reader.hasNext()) {
                    maskb.append(reader.next());
                }
            }
            ipb.append(now);
        }
        Builder builder = new Builder().text(ipb.toString()).eth(ethb.toString()).mask(maskb.toString()).version(version);
        ipb.delete(0, ipb.length());
        ethb.delete(0, ethb.length());
        maskb.delete(0, maskb.length());
        return builder.build();
    }

    public String string() {
        return this.text;
    }

    public Version version() {
        return this.version;
    }

    public String eth() {
        return this.eth;
    }

    public String mask() {
        return this.mask;
    }

    public String toString() {
        return this.text;
    }

    public static enum Version implements IMarkIx
    {
        FOUR(4),
        SIX(6);

        private final int ix;

        private Version(int ix) {
            this.ix = ix;
        }

        @Override
        public int ix() {
            return this.ix;
        }
    }

    private static class Builder {
        private String text;
        private String eth;
        private String mask;
        private Version version;

        private Builder() {
        }

        public IP build() {
            return new IP(this);
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder eth(String eth) {
            this.eth = eth;
            return this;
        }

        public Builder mask(String mask) {
            this.mask = mask;
            return this;
        }
    }
}

