/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.ethernet;

import io.enoa.toolkit.ethernet.EthInfo;
import io.enoa.toolkit.ethernet.IP;
import io.enoa.toolkit.ethernet._EthernetLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Ethernet {
    private List<EthInfo> infs = new ArrayList<EthInfo>();

    public static Ethernet machine() {
        return _EthernetLocal.instance().local();
    }

    Ethernet() {
    }

    void add(EthInfo inf) {
        this.infs.add(inf);
    }

    void unmodifiable() {
        this.infs = Collections.unmodifiableList(this.infs);
    }

    public List<EthInfo> eths() {
        return this.infs;
    }

    public Stream<EthInfo> filter(Predicate<? super EthInfo> predicate) {
        return this.infs.stream().filter(predicate);
    }

    public List<EthInfo> LANS() {
        return this.infs.stream().filter((? super T inf) -> {
            IP ip = inf.ip();
            if (ip == null) {
                return false;
            }
            if (ip.version() == IP.Version.SIX) {
                return false;
            }
            return ip.string().startsWith("192.") || ip.string().startsWith("10.") || ip.string().startsWith("172.") || ip.string().startsWith("169.");
        }).collect(Collectors.toList());
    }

    public EthInfo LAN() {
        return this.LANS().stream().findFirst().orElse(null);
    }
}

