/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.toolkit.ethernet;

import io.enoa.toolkit.ethernet.IP;
import io.enoa.toolkit.ethernet.MAC;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class EthInfo {
    private final String name;
    private final IP ip;
    private final MAC mac;
    private final NetworkInterface nif;
    private final InetAddress address;

    private EthInfo(Builder builder) {
        this.name = builder.name;
        this.ip = builder.ip;
        this.nif = builder.nif;
        this.address = builder.address;
        this.mac = builder.mac;
    }

    Builder builder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public IP ip() {
        return this.ip;
    }

    public MAC mac() {
        return this.mac;
    }

    public NetworkInterface nif() {
        return this.nif;
    }

    public InetAddress address() {
        return this.address;
    }

    public boolean loopback() {
        return this.usaferun(this.nif::isLoopback);
    }

    public boolean virtual() {
        return this.usaferun(this.nif::isVirtual);
    }

    public boolean up() {
        return this.usaferun(this.nif::isUp);
    }

    private <T> T usaferun(Caller<T> caller) {
        try {
            return caller.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString() {
        return "EthInfo{name='" + this.name + '\'' + ", ip=" + this.ip + ", mac=" + this.mac + '}';
    }

    protected static class Builder {
        private String name;
        private IP ip;
        private NetworkInterface nif;
        private InetAddress address;
        private MAC mac;

        protected Builder() {
        }

        private Builder(EthInfo inf) {
            this.name = inf.name;
            this.ip = inf.ip;
            this.nif = inf.nif;
            this.address = inf.address;
            this.mac = inf.mac;
        }

        public EthInfo build() {
            return new EthInfo(this);
        }

        public Builder mac(MAC mac) {
            this.mac = mac;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ip(IP ip) {
            this.ip = ip;
            return this;
        }

        public Builder nif(NetworkInterface nif) {
            this.nif = nif;
            return this;
        }

        public Builder address(InetAddress address) {
            this.address = address;
            return this;
        }
    }

    private static interface Caller<T> {
        public T call() throws Exception;
    }
}

